/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.parsing;

import aima.logic.common.Token;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.parsing.FOLLexer;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.QuantifiedSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.List;

public class FOLParser {
    private FOLLexer lexer;
    protected Token[] lookAheadBuffer;
    protected int lookAhead = 1;

    public FOLParser(FOLLexer lexer) {
        this.lexer = lexer;
        this.lookAheadBuffer = new Token[this.lookAhead];
    }

    public FOLParser(FOLDomain domain) {
        this(new FOLLexer(domain));
    }

    public FOLDomain getFOLDomain() {
        return this.lexer.getFOLDomain();
    }

    public Sentence parse(String s) {
        this.setUpToParse(s);
        return this.parseSentence();
    }

    public void setUpToParse(String s) {
        this.lexer.clear();
        this.lookAheadBuffer = new Token[1];
        this.lexer.setInput(s);
        this.fillLookAheadBuffer();
    }

    private Term parseTerm() {
        Token t = this.lookAhead(1);
        int tokenType = t.getType();
        if (tokenType == 10) {
            return this.parseConstant();
        }
        if (tokenType == 9) {
            return this.parseVariable();
        }
        if (tokenType == 8) {
            return this.parseFunction();
        }
        return null;
    }

    public Term parseVariable() {
        Token t = this.lookAhead(1);
        String value = t.getText();
        this.consume();
        return new Variable(value);
    }

    public Term parseConstant() {
        Token t = this.lookAhead(1);
        String value = t.getText();
        this.consume();
        return new Constant(value);
    }

    public Term parseFunction() {
        Token t = this.lookAhead(1);
        String functionName = t.getText();
        List<Term> terms = this.processTerms();
        return new Function(functionName, terms);
    }

    public Sentence parsePredicate() {
        Token t = this.lookAhead(1);
        String predicateName = t.getText();
        List<Term> terms = this.processTerms();
        return new Predicate(predicateName, terms);
    }

    private List<Term> processTerms() {
        this.consume();
        ArrayList<Term> terms = new ArrayList<Term>();
        this.match("(");
        Term term = this.parseTerm();
        terms.add(term);
        while (this.lookAhead(1).getType() == 4) {
            this.match(",");
            term = this.parseTerm();
            terms.add(term);
        }
        this.match(")");
        return terms;
    }

    public Sentence parseTermEquality() {
        Term term1 = this.parseTerm();
        this.match("=");
        Term term2 = this.parseTerm();
        return new TermEquality(term1, term2);
    }

    public Sentence parseNotSentence() {
        this.match("NOT");
        return new NotSentence(this.parseSentence());
    }

    private Sentence parseSentence() {
        Token t = this.lookAhead(1);
        if (this.lParen(t)) {
            return this.parseParanthizedSentence();
        }
        if (this.lookAhead(1).getType() == 6) {
            return this.parseQuantifiedSentence();
        }
        if (this.notToken(t)) {
            return this.parseNotSentence();
        }
        if (this.predicate(t)) {
            return this.parsePredicate();
        }
        if (this.term(t)) {
            return this.parseTermEquality();
        }
        throw new RuntimeException("parse failed with Token " + t.getText());
    }

    private Sentence parseQuantifiedSentence() {
        String quantifier = this.lookAhead(1).getText();
        this.consume();
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable var = (Variable)this.parseVariable();
        variables.add(var);
        while (this.lookAhead(1).getType() == 4) {
            this.consume();
            var = (Variable)this.parseVariable();
            variables.add(var);
        }
        Sentence sentence = this.parseSentence();
        return new QuantifiedSentence(quantifier, variables, sentence);
    }

    private Sentence parseParanthizedSentence() {
        this.match("(");
        Sentence sen = this.parseSentence();
        while (this.binaryConnector(this.lookAhead(1))) {
            String connector = this.lookAhead(1).getText();
            this.consume();
            Sentence other = this.parseSentence();
            sen = new ConnectedSentence(connector, sen, other);
        }
        this.match(")");
        return sen;
    }

    private boolean binaryConnector(Token t) {
        return t.getType() == 5 && !t.getText().equals("NOT");
    }

    private boolean lParen(Token t) {
        return t.getType() == 2;
    }

    private boolean term(Token t) {
        return t.getType() == 8 || t.getType() == 10 || t.getType() == 9;
    }

    private boolean predicate(Token t) {
        return t.getType() == 7;
    }

    private boolean notToken(Token t) {
        return t.getType() == 5 && t.getText().equals("NOT");
    }

    protected Token lookAhead(int i) {
        return this.lookAheadBuffer[i - 1];
    }

    protected void consume() {
        this.loadNextTokenFromInput();
    }

    protected void loadNextTokenFromInput() {
        boolean eoiEncountered = false;
        for (int i = 0; i < this.lookAhead - 1; ++i) {
            this.lookAheadBuffer[i] = this.lookAheadBuffer[i + 1];
            if (!this.isEndOfInput(this.lookAheadBuffer[i])) continue;
            eoiEncountered = true;
            break;
        }
        if (!eoiEncountered) {
            try {
                this.lookAheadBuffer[this.lookAhead - 1] = this.lexer.nextToken();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isEndOfInput(Token t) {
        return t.getType() == 9999;
    }

    protected void fillLookAheadBuffer() {
        for (int i = 0; i < this.lookAhead; ++i) {
            this.lookAheadBuffer[i] = this.lexer.nextToken();
        }
    }

    protected void match(String terminalSymbol) {
        if (!this.lookAhead(1).getText().equals(terminalSymbol)) {
            throw new RuntimeException("Syntax error detected at match. Expected " + terminalSymbol + " but got " + this.lookAhead(1).getText());
        }
        this.consume();
    }
}

