/*
 * Decompiled with CFR 0.152.
 */
package aima.gui.applications.search.map;

import aima.gui.applications.search.map.AbstractMapAgentController;
import aima.gui.applications.search.map.MapAgentFrame;
import aima.gui.applications.search.map.MapAgentModel;
import aima.gui.framework.AgentAppController;
import aima.gui.framework.AgentAppFrame;
import aima.gui.framework.AgentAppModel;
import aima.gui.framework.SimpleAgentAppDemo;
import aima.search.framework.SearchFactory;
import aima.search.map.AdaptableHeuristicFunction;
import aima.search.map.ExtendableMap;
import aima.search.map.MapAgent;
import aima.search.map.MapEnvironment;
import aima.search.map.Point2D;
import aima.search.map.Scenario;
import aima.search.map.SimplifiedRoadMapOfAustralia;
import aima.search.map.SimplifiedRoadMapOfPartOfRomania;
import java.util.ArrayList;

public class RoutePlanningAgentAppDemo
extends SimpleAgentAppDemo {
    @Override
    public AgentAppModel createModel() {
        return new MapAgentModel();
    }

    @Override
    public AgentAppFrame createFrame() {
        return new RoutePlanningAgentFrame();
    }

    @Override
    public AgentAppController createController() {
        return new RoutePlanningAgentController();
    }

    public static void main(String[] args) {
        new RoutePlanningAgentAppDemo().startApplication();
    }

    static class H2
    extends AdaptableHeuristicFunction {
        H2() {
        }

        @Override
        public double getHeuristicValue(Object state) {
            double result = 0.0;
            Point2D pt1 = this.map.getPosition((String)state);
            Point2D pt2 = this.map.getPosition((String)this.goal);
            if (pt1 != null && pt2 != null) {
                result = pt1.distance(pt2);
            }
            return result;
        }
    }

    static class H1
    extends AdaptableHeuristicFunction {
        H1() {
        }

        @Override
        public double getHeuristicValue(Object state) {
            return 0.0;
        }
    }

    protected static class RoutePlanningAgentController
    extends AbstractMapAgentController {
        protected RoutePlanningAgentController() {
        }

        @Override
        protected void selectScenarioAndDest(int scenarioIdx, int destIdx) {
            ExtendableMap map = new ExtendableMap();
            MapEnvironment env = new MapEnvironment(map);
            String agentLoc = null;
            switch (scenarioIdx) {
                case 0: {
                    SimplifiedRoadMapOfPartOfRomania.initMap(map);
                    agentLoc = "Arad";
                    break;
                }
                case 1: {
                    SimplifiedRoadMapOfPartOfRomania.initMap(map);
                    agentLoc = "Lugoj";
                    break;
                }
                case 2: {
                    SimplifiedRoadMapOfPartOfRomania.initMap(map);
                    agentLoc = "Fagaras";
                    break;
                }
                case 3: {
                    SimplifiedRoadMapOfAustralia.initMap(map);
                    agentLoc = "Sydney";
                    break;
                }
                case 4: {
                    SimplifiedRoadMapOfAustralia.initMap(map);
                    agentLoc = map.randomlyGenerateDestination();
                }
            }
            this.scenario = new Scenario(env, map, agentLoc);
            this.destinations = new ArrayList();
            if (scenarioIdx < 3) {
                switch (destIdx) {
                    case 0: {
                        this.destinations.add("Bucharest");
                        break;
                    }
                    case 1: {
                        this.destinations.add("Eforie");
                        break;
                    }
                    case 2: {
                        this.destinations.add("Neamt");
                        break;
                    }
                    case 3: {
                        this.destinations.add(map.randomlyGenerateDestination());
                    }
                }
            } else {
                switch (destIdx) {
                    case 0: {
                        this.destinations.add("PortHedland");
                        break;
                    }
                    case 1: {
                        this.destinations.add("Albany");
                        break;
                    }
                    case 2: {
                        this.destinations.add("Melbourne");
                        break;
                    }
                    case 3: {
                        this.destinations.add(map.randomlyGenerateDestination());
                    }
                }
            }
        }

        @Override
        protected void prepareModel() {
            ((MapAgentModel)this.model).prepare(this.scenario, this.destinations);
        }

        @Override
        protected AdaptableHeuristicFunction createHeuristic(int heuIdx) {
            switch (heuIdx) {
                case 0: {
                    return new H1();
                }
            }
            return new H2();
        }

        @Override
        protected void startAgent() {
            if (this.destinations.size() != 1) {
                this.frame.logMessage("Error: This agent requires exact one destination.");
                return;
            }
            this.frame.logMessage("<route-planning-simulation-protocol>");
            this.frame.logMessage("search: " + this.search.getClass().getName());
            MapEnvironment env = this.scenario.getEnv();
            String goal = (String)this.destinations.get(0);
            MapAgent agent = new MapAgent(env, this.search, new String[]{goal});
            if (this.heuristic != null) {
                this.frame.logMessage("heuristic: " + this.heuristic.getClass().getName());
                agent.setHeuristicFunction(this.heuristic.getAdaptation(goal, this.scenario.getAgentMap()));
            }
            env.addAgent(agent, this.scenario.getInitAgentLocation());
            env.stepUntilDone();
            this.frame.logMessage("</route-planning-simulation-protocol>\n");
        }
    }

    protected static class RoutePlanningAgentFrame
    extends MapAgentFrame {
        private MapType usedMap = null;
        private static String[] ROMANIA_DESTS = new String[]{"D1 (to Bucharest)", "D2 (to Eforie)", "D3 (to Neamt)", "D4 (to random)"};
        private static String[] AUSTRALIA_DESTS = new String[]{"D1 (to Port Hedland)", "D2 (to Albany)", "D3 (to Melbourne)", "D4 (to random)"};

        public RoutePlanningAgentFrame() {
            this.setTitle("RPA - the Route Planning Agent");
            this.setSelectorItems(SCENARIO_SEL, new String[]{"S1 (Romania, from Arad)", "S2 (Romania, from Lugoj)", "S3 (Romania, from Fagaras)", "S4 (Australia, from Sydney)", "S4 (Australia, from Random)"}, 0);
            this.setSelectorItems(SEARCH_MODE_SEL, SearchFactory.getInstance().getSearchModeNames(), 1);
            this.setSelectorItems(HEURISTIC_SEL, new String[]{"H1 (=0)", "H2 (sld to goal)"}, 1);
        }

        @Override
        protected void selectionChanged() {
            MapType mtype;
            AgentAppFrame.SelectionState state = this.getSelection();
            int scenarioIdx = state.getValue(MapAgentFrame.SCENARIO_SEL);
            MapType mapType = mtype = scenarioIdx < 3 ? MapType.ROMANIA : MapType.AUSTRALIA;
            if (mtype != this.usedMap) {
                this.usedMap = mtype;
                String[] items = null;
                switch (mtype) {
                    case ROMANIA: {
                        items = ROMANIA_DESTS;
                        break;
                    }
                    case AUSTRALIA: {
                        items = AUSTRALIA_DESTS;
                    }
                }
                this.setSelectorItems(DESTINATION_SEL, items, 0);
            }
            super.selectionChanged();
        }

        public static enum MapType {
            ROMANIA,
            AUSTRALIA;

        }
    }
}

