/*
 * Decompiled with CFR 0.152.
 */
package aima.gui.applications;

import aima.basic.Agent;
import aima.basic.vaccum.ModelBasedTVEVaccumAgent;
import aima.basic.vaccum.ReflexVaccumAgent;
import aima.basic.vaccum.ReflexVaccumAgentWithState;
import aima.basic.vaccum.SimpleReflexVaccumAgent;
import aima.basic.vaccum.TableDrivenVaccumAgent;
import aima.basic.vaccum.TrivialVaccumEnvironment;
import aima.gui.framework.AgentAppController;
import aima.gui.framework.AgentAppFrame;
import aima.gui.framework.AgentAppModel;
import aima.gui.framework.AgentView;
import aima.gui.framework.SimpleAgentAppDemo;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;

public class VacuumAppDemo
extends SimpleAgentAppDemo {
    @Override
    public AgentAppModel createModel() {
        return new VacuumModel();
    }

    @Override
    public AgentAppFrame createFrame() {
        return new VacuumFrame();
    }

    @Override
    public AgentAppController createController() {
        return new VacuumController();
    }

    public static void main(String[] args) {
        new VacuumAppDemo().startApplication();
    }

    protected static class VacuumController
    extends AgentAppController {
        protected VacuumController() {
        }

        @Override
        public void clearAgent() {
        }

        @Override
        public void prepareAgent() {
            AgentAppFrame.SelectionState selState = this.frame.getSelection();
            TrivialVaccumEnvironment env = null;
            Agent agent = null;
            switch (selState.getValue(VacuumFrame.ENV_SEL)) {
                case 0: {
                    env = new TrivialVaccumEnvironment();
                }
            }
            switch (selState.getValue(VacuumFrame.AGENT_SEL)) {
                case 0: {
                    agent = new SimpleReflexVaccumAgent();
                    break;
                }
                case 1: {
                    agent = new ReflexVaccumAgent();
                    break;
                }
                case 2: {
                    agent = new ReflexVaccumAgentWithState();
                    break;
                }
                case 3: {
                    agent = new TableDrivenVaccumAgent();
                    break;
                }
                case 4: {
                    agent = new ModelBasedTVEVaccumAgent();
                }
            }
            ((VacuumModel)this.model).setEnv(env);
            ((VacuumModel)this.model).setAgent(agent);
            if (env != null && agent != null) {
                env.addAgent(agent);
                env.registerView(this.model);
                this.frame.modelChanged();
            }
        }

        @Override
        public void runAgent() {
            VacuumModel vmodel = (VacuumModel)this.model;
            this.frame.logMessage("<simulation-log>");
            vmodel.getEnv().stepUntilDone();
            this.frame.logMessage("Performance: " + vmodel.getEnv().getAgentperformance(vmodel.getAgent()));
            this.frame.logMessage("</simulation-log>");
            this.frame.setStatus("Task completed.");
        }
    }

    protected static class VacuumView
    extends AgentView {
        Hashtable<String, int[]> dirtLookup = new Hashtable();

        protected VacuumView() {
        }

        int[] getDirt(String location) {
            int[] coords = this.dirtLookup.get(location);
            if (coords == null) {
                Random rand = new Random();
                int size = rand.nextInt(8) + 4;
                coords = new int[2 * size];
                for (int i = 0; i < size; ++i) {
                    coords[2 * i] = rand.nextInt(6) + 1;
                    coords[2 * i + 1] = rand.nextInt(8) + 1;
                }
            }
            this.dirtLookup.put(location, coords);
            return coords;
        }

        @Override
        public void paint(Graphics g) {
            VacuumModel vmodel = (VacuumModel)this.model;
            List<String> locations = vmodel.getLocations();
            this.adjustTransformation(0.0, 0.0, 11 * locations.size() - 1, 10.0);
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.white);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int i = 0; i < locations.size(); ++i) {
                String location = locations.get(i);
                g2.setColor(Color.black);
                g2.drawRect(this.x(11 * i), this.y(0.0), this.scale(10), this.scale(10));
                if (vmodel.isDirty(location)) {
                    int[] coords = this.getDirt(location);
                    for (int j = 0; j < coords.length; j += 2) {
                        g2.setColor(Color.lightGray);
                        g2.fillOval(this.x(11 * i + coords[j]), this.y(coords[j + 1]), this.scale(3), this.scale(2));
                    }
                }
                g2.setColor(Color.black);
                g2.drawString(location, this.x(11 * i) + 10, this.y(0.0) + 20);
                if (!vmodel.hasAgent(location)) continue;
                g2.setColor(Color.red);
                g2.fillOval(this.x(11 * i + 2), this.y(2.0), this.scale(6), this.scale(6));
            }
        }
    }

    protected static class VacuumFrame
    extends AgentAppFrame {
        public static String ENV_SEL = "EnvSelection";
        public static String AGENT_SEL = "AgentSelection";

        public VacuumFrame() {
            this.setAgentView(new VacuumView());
            this.setSelectors(new String[]{ENV_SEL, AGENT_SEL}, new String[]{"Select Environment", "Select Agent"});
            this.setSelectorItems(ENV_SEL, new String[]{"A/B Environment"}, 0);
            this.setSelectorItems(AGENT_SEL, new String[]{"SimpleReflexVaccumAgent", "ReflexVaccumAgent", "ReflexVaccumAgentWithState", "TableDrivenVaccumAgent", "ModelBasedTVEVaccumAgent"}, 0);
            this.setTitle("Vacuum Agent Application");
            this.setSize(800, 400);
            this.setUpdateDelay(500);
        }
    }

    protected static class VacuumModel
    extends AgentAppModel {
        private TrivialVaccumEnvironment env;
        private Agent agent;
        public static String DIRTY = "Dirty";

        protected VacuumModel() {
        }

        public void setEnv(TrivialVaccumEnvironment env) {
            this.env = env;
        }

        public TrivialVaccumEnvironment getEnv() {
            return this.env;
        }

        public void setAgent(Agent agent) {
            this.agent = agent;
        }

        public Agent getAgent() {
            return this.agent;
        }

        public List<String> getLocations() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.env != null) {
                result.add("A");
                result.add("B");
            }
            return result;
        }

        public boolean isDirty(String location) {
            return DIRTY.equals(this.env.getLocationStatus(location));
        }

        public boolean hasAgent(String location) {
            return this.agent != null && location.equals(this.env.getAgentLocation(this.agent));
        }
    }
}

