/*
 * Decompiled with CFR 0.152.
 */
package mcgraphresolver.controllers;

import aima.search.framework.SearchAgent;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXSnackbar;
import com.jfoenix.controls.JFXToggleButton;
import fxgraph.FXEdge;
import fxgraph.FXGraph;
import fxgraph.FXGraphBuilder;
import fxgraph.FXNode;
import fxgraph.FXNodeGeneric;
import fxgraph.FXNodeTree;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import mcgraphresolver.bucket.Operation;
import mcgraphresolver.bucket.TreeNode;
import mcgraphresolver.controllers.ChooseAlgorithmController;
import mcgraphresolver.utils.SharePreferencesHandler;
import mcgraphresolver.utils.Utils;

public class ExpansionTreeController
implements Initializable {
    public JFXButton btnSnapshot;
    public BorderPane borderPaneRoot;
    public BorderPane anchorPaneGraph;
    public Pane paneGraphView;
    public JFXToggleButton toggleShowOperations;
    public ListView listViewOperation;
    public TitledPane titledPaneOperations;
    public Label lblPathCost;
    public Label lblNodesExpanded;
    public Label lblQueueSize;
    public Label lblMaxQueueSize;
    public VBox vboxLoading;
    public Label lblTitleSearch;
    public JFXButton btnPrint;
    private ResourceBundle resourceBundle;
    public Utils utils = new Utils();
    private SharePreferencesHandler sharePreferencesHandler;
    private JFXSnackbar snackbar;
    private FXGraph fxGraphExpansionTree;
    private List<Operation> listOperation;
    private TreeNode tree;
    private SearchAgent agent;
    private FXGraph fxGraph;
    private int autoIncrementIdFXNodeTree = 0;
    private ChooseAlgorithmController.algorithm choosenAlgorithm;

    public void initialize(URL location, ResourceBundle resources) {
        this.resourceBundle = resources;
        FXGraphBuilder theBuilder = FXGraphBuilder.create();
        this.fxGraphExpansionTree = theBuilder.build();
        this.listViewOperation.getSelectionModel().selectedIndexProperty().addListener((observable, oldvalue, newValue) -> Platform.runLater(() -> this.listViewOperation.getSelectionModel().select(-1)));
        this.snackbar = new JFXSnackbar((Pane)this.borderPaneRoot);
        this.btnSnapshot.setOnAction(event -> this.saveImage());
        this.btnPrint.setOnAction(event -> this.printGraphToPrinter());
        this.toggleShowOperations.selectedProperty().addListener((observable, oldValue, newValue) -> {
            for (FXNode fxNode : this.fxGraphExpansionTree.getModel().getNodes()) {
                ((FXNodeTree)fxNode).getLblF().setVisible(newValue.booleanValue());
            }
        });
    }

    public void setTitleSearch(String titleSearch) {
        this.lblTitleSearch.setText(titleSearch);
    }

    public void setSharePreferencesHandles(SharePreferencesHandler sharePreferencesHandler) {
        this.sharePreferencesHandler = sharePreferencesHandler;
    }

    public void setChoosenAlgorithmType(ChooseAlgorithmController.algorithm choosenAlgorithm) {
        this.choosenAlgorithm = choosenAlgorithm;
    }

    public void setTree(TreeNode tree) {
        this.tree = tree;
    }

    public void setAgent(SearchAgent agent) {
        this.agent = agent;
    }

    public void setFxGraph(FXGraph fxGraph) {
        this.fxGraph = fxGraph;
    }

    public void resizeFxGraph() {
        this.fxGraphExpansionTree.setSizeGraph(this.paneGraphView.getWidth(), this.paneGraphView.getHeight());
    }

    public void populateItems() {
        this.listOperation = new ArrayList<Operation>();
        this.fxGraphExpansionTree.setSizeGraph(this.paneGraphView.getWidth(), this.paneGraphView.getHeight());
        this.printExpansionTree(this.tree, this.paneGraphView.getWidth() - 200.0, 50.0, 380);
        this.paneGraphView.getChildren().clear();
        this.fxGraphExpansionTree.setVisible(false);
        this.vboxLoading.setVisible(true);
        Task<Boolean> task = new Task<Boolean>(){

            public Boolean call() {
                ExpansionTreeController.this.paneGraphView.getChildren().add((Object)ExpansionTreeController.this.fxGraphExpansionTree);
                ExpansionTreeController.this.fxGraphExpansionTree.getZoomHandler().zoomIn(ExpansionTreeController.this.fxGraph.getModel().getNodes().size() / 2);
                return true;
            }
        };
        task.setOnSucceeded(e -> Platform.runLater(() -> {
            this.vboxLoading.setVisible(false);
            this.fxGraphExpansionTree.setVisible(true);
            this.resizeFxGraph();
        }));
        new Thread((Runnable)task).run();
        ExpansionTreeController.printActions(this.agent.getActions(), this.fxGraphExpansionTree, (FXNodeTree)this.fxGraphExpansionTree.getModel().getNodeTree(this.fxGraph.getModel().getSourceNode().getBtnNode().getText()));
        this.printInstrumentation(this.agent.getInstrumentation());
        this.listViewOperation.getItems().clear();
        this.refreshOperationList(this.tree);
        this.listViewOperation.getItems().addAll(this.listOperation);
        this.btnSnapshot.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}), () -> this.btnSnapshot.fire());
    }

    private <T> FXNodeTree printExpansionTree(TreeNode<T> node, double x, double y, int range) {
        FXNodeGeneric fxNodeParent = (FXNodeGeneric)node.getData();
        FXNodeTree fxNodeTree = new FXNodeTree(this.autoIncrementIdFXNodeTree, fxNodeParent.getBtnNode().getText(), node.getLabelF(), "" + node.getExpansionOrder(), this.fxGraphExpansionTree);
        ++this.autoIncrementIdFXNodeTree;
        fxNodeTree.setOwner(this.fxGraphExpansionTree);
        fxNodeTree.setPosition(x, y);
        fxNodeTree.setBackgroundColor(Color.web((String)this.sharePreferencesHandler.getColorResource("color_generic_node", "#00b8d4")));
        this.fxGraphExpansionTree.addNode(fxNodeTree);
        int offset = 0;
        if (node.getChildren().size() > 1) {
            offset = range / node.getChildren().size();
        }
        boolean isOddChildren = node.getChildren().size() % 2 == 0;
        int i = 0;
        int newX = -offset;
        int yOffset = 100;
        if (!this.checkOverlappingNodeOnGraph((ObservableList<Node>)this.fxGraphExpansionTree.getContentPane().getChildren(), x + (double)newX + (double)(offset * i), y + (double)yOffset)) {
            yOffset += 100;
            this.fxGraphExpansionTree.getZoomHandler().zoomIn(2);
        }
        for (TreeNode<T> o : node.getChildren()) {
            if (!(o instanceof TreeNode)) continue;
            TreeNode<T> treeNode = o;
            FXEdge fxEdge = new FXEdge(this.fxGraphExpansionTree, fxNodeTree, this.printExpansionTree(treeNode, x + (double)newX + (double)(offset * i), y + (double)yOffset, range));
            fxEdge.setOriented(false);
            this.fxGraphExpansionTree.addEdge(fxEdge);
            ++i;
            if (!isOddChildren) continue;
            newX += offset;
        }
        return fxNodeTree;
    }

    private boolean checkOverlappingNodeOnGraph(ObservableList<Node> nodes, double x, double y) {
        for (Node node : nodes) {
            Bounds boundsInScene = node.localToScene(node.getBoundsInLocal());
            double minX = boundsInScene.getMinX();
            double maxX = boundsInScene.getMaxX();
            double minY = boundsInScene.getMinY();
            double maxY = boundsInScene.getMaxY();
            if (!(x <= maxX) || !(x >= minX) || !(y <= maxY) || !(y >= minY)) continue;
            return false;
        }
        return true;
    }

    private void printInstrumentation(Properties properties) {
        Iterator<Object> keys = properties.keySet().iterator();
        int i = 0;
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String property = properties.getProperty(key);
            switch (i) {
                case 0: {
                    this.lblPathCost.setText(String.format("%s: %s", this.resourceBundle.getString("text_path_cost"), property));
                    break;
                }
                case 1: {
                    this.lblNodesExpanded.setText(String.format("%s: %s", this.resourceBundle.getString("text_node_expanded"), property));
                    break;
                }
                case 2: {
                    this.lblQueueSize.setText(String.format("%s: %s", this.resourceBundle.getString("text_queue_size"), property));
                    break;
                }
                case 3: {
                    this.lblMaxQueueSize.setText(String.format("%s: %s", this.resourceBundle.getString("text_max_queue_size"), property));
                }
            }
            ++i;
        }
    }

    private static void printActions(List actions2, FXGraph fxGraphTree, FXNodeTree source) {
        SharePreferencesHandler sharePreferencesHandler = new SharePreferencesHandler();
        source.setBackgroundColor(Color.web((String)sharePreferencesHandler.getColorResource("color_destination_node", "#00c853")));
        for (int i = 0; i < actions2.size(); ++i) {
            String action = (String)actions2.get(i);
            source = ExpansionTreeController.getNodeFromEdgesByAction(source, fxGraphTree, action);
        }
    }

    private static FXNodeTree getNodeFromEdgesByAction(FXNodeTree parent, FXGraph fxGraphTree, String action) {
        SharePreferencesHandler sharePreferencesHandler = new SharePreferencesHandler();
        Set<FXEdge> edges = fxGraphTree.getModel().getEdgesFromNodeTree(parent);
        for (FXEdge fxEdge : edges) {
            FXNodeTree fxNodeTree = (FXNodeTree)fxEdge.getDestination();
            if (!fxNodeTree.getBtnNode().getText().equals(action)) continue;
            fxNodeTree.setBackgroundColor(Color.web((String)sharePreferencesHandler.getColorResource("color_destination_node", "#00c853")));
            return fxNodeTree;
        }
        return parent;
    }

    private <T> void refreshOperationList(TreeNode<T> node) {
        FXNodeGeneric fxNodeGeneric = (FXNodeGeneric)node.getData();
        String item = String.format("%s [%s]", fxNodeGeneric.getBtnNode().getText(), node.getLabelF());
        int expansionOrder = Integer.MAX_VALUE;
        if (!node.getExpansionOrder().equals("/")) {
            expansionOrder = Integer.parseInt(node.getExpansionOrder());
        }
        Operation operation = new Operation(item, expansionOrder);
        operation.setText(operation.toString());
        operation.setStyle("-fx-font-family: 'Roboto Medium'; -fx-font-size: 12px");
        switch (fxNodeGeneric.getType()) {
            case SOURCE_NODE: {
                operation.setTextFill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_source_node", "#d50000")));
                break;
            }
            case DESTINATION_NODE: {
                operation.setTextFill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_destination_node", "#00c853")));
                break;
            }
            default: {
                operation.setTextFill((Paint)Color.BLACK);
            }
        }
        this.listOperation.add(operation);
        for (TreeNode<T> o : node.getChildren()) {
            if (!(o instanceof TreeNode)) continue;
            this.refreshOperationList(o);
        }
        Collections.sort(this.listOperation, (o1, o2) -> o1.getExpansionOrder() < o2.getExpansionOrder() ? -1 : 1);
    }

    private void saveImage() {
        Stage stage;
        File selectedDirectory;
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(this.resourceBundle.getString("text_title_file_chooser_for_image"));
        File defaultFolder = new File(this.sharePreferencesHandler.getDefaultFolderForSnapshot(""));
        if (defaultFolder.exists()) {
            directoryChooser.setInitialDirectory(defaultFolder);
        }
        if ((selectedDirectory = directoryChooser.showDialog((Window)(stage = new Stage()))) != null) {
            String stringChoosenAlgorithm;
            String absolutePathDir = selectedDirectory.getAbsolutePath();
            BufferedImage bufferedImage = new BufferedImage(550, 400, 2);
            switch (this.choosenAlgorithm) {
                case ASTAR_SEARCH: {
                    stringChoosenAlgorithm = this.resourceBundle.getString("text_snapshot_name_astar");
                    break;
                }
                case BREADTH_FIRST_SEARCH: {
                    stringChoosenAlgorithm = this.resourceBundle.getString("text_snapshot_name_breadth_first");
                    break;
                }
                case DEPTH_FIRST_SEARCH: {
                    stringChoosenAlgorithm = this.resourceBundle.getString("text_snapshot_name_depth_first");
                    break;
                }
                case GREEDY_BEST_FIRST_SEARCH: {
                    stringChoosenAlgorithm = this.resourceBundle.getString("text_snapshot_name_greedy_best_first");
                    break;
                }
                default: {
                    stringChoosenAlgorithm = this.resourceBundle.getString("text_snapshot_name_astar");
                }
            }
            String absolutePath = String.format("%s%s%s_%s_%s.%s", absolutePathDir, System.getProperty("file.separator"), stringChoosenAlgorithm, this.resourceBundle.getString("text_snapshot_name_tree"), Utils.getTimestamp(), "png");
            File file = new File(absolutePath);
            WritableImage snapshot = this.paneGraphView.snapshot(new SnapshotParameters(), null);
            BufferedImage image = SwingFXUtils.fromFXImage((Image)snapshot, (BufferedImage)bufferedImage);
            try {
                Graphics2D gd = (Graphics2D)image.getGraphics();
                gd.translate(this.paneGraphView.getWidth(), this.paneGraphView.getHeight());
                ImageIO.write((RenderedImage)image, "png", file);
                this.snackbar.show(this.resourceBundle.getString("text_screenshot_acquired"), this.resourceBundle.getString("text_open_saved_image"), 5000L, Utils.openFileWithDefaultOSProgram(file));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.sharePreferencesHandler.getCompleteSnapshot()) {
                this.saveListFile(selectedDirectory, stringChoosenAlgorithm);
            }
        }
    }

    private void printGraphToPrinter() {
        for (FXNode node : this.fxGraphExpansionTree.getModel().getNodes()) {
            if (node instanceof FXNodeTree) {
                VBox vBox = new VBox();
                HBox hBox = new HBox();
                Label lblF = new Label(((FXNodeTree)node).getLblF().getText());
                lblF.setStyle("-fx-font-size: 13px");
                Label lblOrder = new Label(((FXNodeTree)node).getLblOrder().getText());
                lblOrder.setStyle("-fx-font-size: 15px; -fx-border-color: black; -fx-padding: 3px;");
                if (((FXNodeTree)node).getLblOrder().getText().contains("/")) {
                    lblOrder.setVisible(false);
                }
                Color color = (Color)((BackgroundFill)((FXNodeTree)node).getBtnNode().getBackground().getFills().get(0)).getFill();
                Button btnNode = new Button(((FXNodeTree)node).getBtnNode().getText());
                btnNode.getStyleClass().add((Object)"custom-jfx-button-fab-node");
                btnNode.setStyle("-fx-background-color: " + Utils.toRGBCode(color) + ";");
                lblF.setTextFill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_estimate", Utils.toRGBCode(Color.BLACK))));
                lblOrder.setTextFill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_source_node", "#d50000")));
                btnNode.setTextFill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_label_inside_node", Utils.toRGBCode(Color.WHITE))));
                btnNode.setMouseTransparent(true);
                vBox.setAlignment(Pos.CENTER);
                vBox.setSpacing(5.0);
                hBox.setAlignment(Pos.CENTER);
                hBox.setSpacing(5.0);
                vBox.setPadding(new Insets(2.0));
                hBox.getChildren().add((Object)btnNode);
                hBox.getChildren().add((Object)lblOrder);
                vBox.getChildren().add((Object)lblF);
                vBox.getChildren().add((Object)hBox);
                vBox.requestFocus();
                vBox.setLayoutX(node.getWrappedNode().getLayoutX());
                vBox.setLayoutY(node.getWrappedNode().getLayoutY());
                vBox.setScaleX(node.getWrappedNode().getScaleX());
                vBox.setScaleY(node.getWrappedNode().getScaleY());
                this.paneGraphView.getChildren().add((Object)vBox);
            }
            node.getWrappedNode().setVisible(false);
        }
        try {
            Utils.printNode((Node)this.paneGraphView);
            for (FXNode fxNode : this.fxGraphExpansionTree.getModel().getNodes()) {
                fxNode.getWrappedNode().setVisible(true);
            }
            this.paneGraphView.getChildren().clear();
            this.paneGraphView.getChildren().add((Object)this.fxGraphExpansionTree);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private void saveListFile(File dirDestination, String stringChoosenAlgorithm) {
        if (dirDestination != null) {
            String absolutePathDir = dirDestination.getAbsolutePath();
            String absolutePath = String.format("%s%s%s_%s_%s.%s", absolutePathDir, System.getProperty("file.separator"), stringChoosenAlgorithm, this.resourceBundle.getString("text_snapshot_name_operation_list"), Utils.getTimestamp(), "txt");
            ObservableList list = this.listViewOperation.getItems();
            PrintWriter fw = null;
            try {
                fw = new PrintWriter(absolutePath);
                BufferedWriter bw = new BufferedWriter(fw);
                for (Object o : list) {
                    if (!(o instanceof Label)) continue;
                    bw.write(((Label)o).getText());
                    bw.newLine();
                }
                bw.newLine();
                bw.write("-----------------");
                bw.newLine();
                bw.write(this.lblPathCost.getText());
                bw.newLine();
                bw.write(this.lblNodesExpanded.getText());
                bw.newLine();
                bw.write(this.lblQueueSize.getText());
                bw.newLine();
                bw.write(this.lblMaxQueueSize.getText());
                bw.newLine();
                bw.close();
                fw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @FXML
    private void handleCloseAction(ActionEvent event) {
        Node source = (Node)event.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    public void handleRefresh(ActionEvent actionEvent) {
        this.paneGraphView.getChildren().clear();
        this.resizeFxGraph();
        this.paneGraphView.getChildren().add((Object)this.fxGraphExpansionTree);
    }
}

