/*
 * Decompiled with CFR 0.152.
 */
package fxgraph;

import fxgraph.FXEdge;
import fxgraph.FXEdgeWayPoint;
import fxgraph.FXGraph;
import fxgraph.FXNode;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;

public class FXGraphMouseHandler {
    private FXGraph graph;
    private EventHandler<MouseEvent> mousePressedEventHandler;
    private EventHandler<MouseEvent> mouseDraggedEventHandler;
    private EventHandler<MouseEvent> mouseReleasedEventHandler;
    private EventHandler<ScrollEvent> scrolLEventHandler;

    public FXGraphMouseHandler(FXGraph aGraph) {
        this.graph = aGraph;
        this.mousePressedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent aEvent) {
                Object theSource = aEvent.getSource();
                if (theSource instanceof Node) {
                    Node theNode = (Node)theSource;
                    Object theUserData = theNode.getUserData();
                    if (theUserData instanceof FXNode) {
                        ((FXGraphMouseHandler)FXGraphMouseHandler.this).graph.currentTool.mousePressedOnNode(aEvent, (FXNode)theUserData);
                    } else if (theUserData instanceof FXEdge) {
                        ((FXGraphMouseHandler)FXGraphMouseHandler.this).graph.currentTool.mousePressedOnEdge(aEvent, (FXEdge)theUserData);
                    } else if (theUserData instanceof FXEdgeWayPoint) {
                        ((FXGraphMouseHandler)FXGraphMouseHandler.this).graph.currentTool.mousePressedOnEdgeWayPoint(aEvent, (FXEdgeWayPoint)theUserData);
                    } else {
                        ((FXGraphMouseHandler)FXGraphMouseHandler.this).graph.currentTool.mousePressed(aEvent);
                    }
                } else {
                    ((FXGraphMouseHandler)FXGraphMouseHandler.this).graph.currentTool.mousePressed(aEvent);
                }
                aEvent.consume();
            }
        };
        this.mouseDraggedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent aEvent) {
                ((FXGraphMouseHandler)FXGraphMouseHandler.this).graph.currentTool.mouseDragged(aEvent);
                aEvent.consume();
            }
        };
        this.mouseReleasedEventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent aEvent) {
                ((FXGraphMouseHandler)FXGraphMouseHandler.this).graph.currentTool.mouseReleased(aEvent);
                aEvent.consume();
            }
        };
        this.scrolLEventHandler = new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent aEvent) {
                if (aEvent.getDeltaY() > 0.0) {
                    ((FXGraphMouseHandler)FXGraphMouseHandler.this).graph.zoomHandler.zoomOneStepOut();
                } else {
                    ((FXGraphMouseHandler)FXGraphMouseHandler.this).graph.zoomHandler.zoomOneStepIn();
                }
            }
        };
        aGraph.setOnScroll(this.scrolLEventHandler);
    }

    public void registerHandlerFor(Node aNode) {
        aNode.setOnMouseDragged(this.mouseDraggedEventHandler);
        aNode.setOnMousePressed(this.mousePressedEventHandler);
        aNode.setOnMouseReleased(this.mouseReleasedEventHandler);
        aNode.setOnScroll(this.scrolLEventHandler);
    }

    public void registerNewNode(FXNode aNode) {
        this.registerHandlerFor(aNode.wrappedNode);
    }

    public void registerNewEdge(FXEdge aEdge) {
        this.registerHandlerFor(aEdge.displayShape);
        for (Node theNode : aEdge.wayPointHandles.values()) {
            this.registerHandlerFor(theNode);
        }
    }
}

