/*
 * Decompiled with CFR 0.152.
 */
package fxgraph;

import fxgraph.FXEdge;
import fxgraph.FXNode;
import fxgraph.FXNodeGeneric;
import fxgraph.FXNodeTree;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.scene.Node;

public class FXGraphModel {
    private Map<Node, FXNode> nodes = new HashMap<Node, FXNode>();
    private Set<FXEdge> edges = new HashSet<FXEdge>();

    public void registerNewNode(FXNode aNode) {
        this.nodes.put(aNode.wrappedNode, aNode);
    }

    public Collection<FXNode> getNodes() {
        return this.nodes.values();
    }

    public Map<Node, FXNode> getNodesMap() {
        return this.nodes;
    }

    public void removeEdge(FXEdge fxEdge) {
        this.edges.remove(fxEdge);
    }

    public void removeNode(FXNodeGeneric fxNodeGeneric) {
        this.nodes.remove(fxNodeGeneric.getVBox());
    }

    public void registerNewEdge(FXEdge aEdge) {
        this.edges.add(aEdge);
    }

    public Set<FXEdge> getEdges() {
        return this.edges;
    }

    public FXNode getNodeGeneric(String label) {
        Collection<FXNode> collectionNodes = this.getNodes();
        for (FXNode fxNode : collectionNodes) {
            if (!(fxNode instanceof FXNodeGeneric) || !((FXNodeGeneric)fxNode).getBtnNode().getText().equalsIgnoreCase(label)) continue;
            return fxNode;
        }
        return null;
    }

    public FXNode getNodeTree(String label) {
        Collection<FXNode> collectionNodes = this.getNodes();
        for (FXNode fxNode : collectionNodes) {
            if (!(fxNode instanceof FXNodeTree) || !((FXNodeTree)fxNode).getBtnNode().getText().equalsIgnoreCase(label)) continue;
            return fxNode;
        }
        return null;
    }

    public boolean exists(String label) {
        Collection<FXNode> collectionNodes = this.getNodes();
        for (FXNode fxNode : collectionNodes) {
            if (!(fxNode instanceof FXNodeGeneric) || !((FXNodeGeneric)fxNode).getBtnNode().getText().equalsIgnoreCase(label)) continue;
            return true;
        }
        return false;
    }

    public Set<FXEdge> getEdgesFromNode(FXNode fxNode) {
        HashSet<FXEdge> edgesFromNode = new HashSet<FXEdge>();
        for (FXEdge fxEdge : this.edges) {
            if (!fxEdge.getSource().equals(fxNode) && !fxEdge.getDestination().equals(fxNode)) continue;
            edgesFromNode.add(fxEdge);
        }
        return edgesFromNode;
    }

    public Set<FXEdge> getEdgesFromNodeTree(FXNodeTree fxNodeTree) {
        HashSet<FXEdge> edgesFromNode = new HashSet<FXEdge>();
        for (FXEdge fxEdge : this.edges) {
            if (((FXNodeTree)fxEdge.getSource()).getId() != fxNodeTree.getId() && ((FXNodeTree)fxEdge.getDestination()).getId() != fxNodeTree.getId()) continue;
            edgesFromNode.add(fxEdge);
        }
        return edgesFromNode;
    }

    public int countNodes(FXNodeGeneric.nodeType nodeType2) {
        int countNode = 0;
        for (FXNode node : this.getNodes()) {
            if (((FXNodeGeneric)node).getType() != nodeType2) continue;
            ++countNode;
        }
        return countNode;
    }

    public int countEdgesWithoutDuplicate() {
        int countNode = 0;
        for (FXEdge edge : this.getEdges()) {
            ++countNode;
        }
        return countNode / 2;
    }

    public int countEdgesWitDuplicate() {
        int countNode = 0;
        for (FXEdge edge : this.getEdges()) {
            ++countNode;
        }
        return countNode;
    }

    public Set<FXEdge> getEdgesWithoutDuplicate() {
        HashSet<FXEdge> edgesWithoutDuplicate = new HashSet<FXEdge>();
        for (FXEdge fxEdge : this.edges) {
            if (this.isDuplicate(edgesWithoutDuplicate, fxEdge)) continue;
            edgesWithoutDuplicate.add(fxEdge);
        }
        return edgesWithoutDuplicate;
    }

    public Set<FXEdge> getEdgesWithoutDuplicateFromSourceNodeEdge(FXNode fxNodeGeneric) {
        HashSet<FXEdge> edgesWithoutDuplicate = new HashSet<FXEdge>();
        for (FXEdge fxEdge : this.edges) {
            if (this.isDuplicate(edgesWithoutDuplicate, fxEdge) || !fxEdge.getSource().equals(fxNodeGeneric)) continue;
            edgesWithoutDuplicate.add(fxEdge);
        }
        return edgesWithoutDuplicate;
    }

    public boolean isDuplicate(Set<FXEdge> edges, FXEdge fxEdgeToCheck) {
        String fxNodeGenericSourceToCheckLabel = ((FXNodeGeneric)fxEdgeToCheck.getSource()).getBtnNode().getText();
        String fxNodeGenericDestinationToCheckLabel = ((FXNodeGeneric)fxEdgeToCheck.getDestination()).getBtnNode().getText();
        for (FXEdge fxEdge : edges) {
            FXNodeGeneric fxNodeGenericSource = (FXNodeGeneric)fxEdge.getSource();
            FXNodeGeneric fxNodeGenericDestination = (FXNodeGeneric)fxEdge.getDestination();
            String fxNodeGenericSourceLabel = fxNodeGenericSource.getBtnNode().getText();
            String fxNodeGenericDestinationLabel = fxNodeGenericDestination.getBtnNode().getText();
            if ((!fxNodeGenericSourceLabel.equalsIgnoreCase(fxNodeGenericSourceToCheckLabel) || !fxNodeGenericDestinationLabel.equalsIgnoreCase(fxNodeGenericDestinationToCheckLabel)) && (!fxNodeGenericSourceLabel.equalsIgnoreCase(fxNodeGenericDestinationToCheckLabel) || !fxNodeGenericDestinationLabel.equalsIgnoreCase(fxNodeGenericSourceToCheckLabel))) continue;
            return true;
        }
        return false;
    }

    public Collection<FXNode> getNodesByNodeType(FXNodeGeneric.nodeType nodeType2) {
        HashMap<Node, FXNode> nodes = new HashMap<Node, FXNode>();
        for (FXNode fxNode : this.getNodes()) {
            FXNodeGeneric fxNodeGeneric = (FXNodeGeneric)fxNode;
            if (fxNodeGeneric.getType() != nodeType2) continue;
            nodes.put(fxNode.wrappedNode, fxNode);
        }
        return nodes.values();
    }

    public FXNodeGeneric getSourceNode() {
        for (FXNode fxNode : this.getNodes()) {
            if (((FXNodeGeneric)fxNode).getType() != FXNodeGeneric.nodeType.SOURCE_NODE) continue;
            return (FXNodeGeneric)fxNode;
        }
        return null;
    }

    public FXNodeTree getSourceNodeTree() {
        for (FXNode fxNode : this.getNodes()) {
            if (((FXNodeTree)fxNode).getType() != FXNodeTree.nodeType.SOURCE_NODE) continue;
            return (FXNodeTree)fxNode;
        }
        return null;
    }

    public FXEdge getEdge(FXNode source, FXNode destination) {
        for (FXEdge fxEdge : this.edges) {
            if (!fxEdge.getSource().equals(source) || !fxEdge.getDestination().equals(destination)) continue;
            return fxEdge;
        }
        return null;
    }
}

