/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.searches;

import aima.search.framework.GraphSearch;
import aima.search.framework.Problem;
import aima.search.framework.SearchAgent;
import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensGoalTest;
import aima.search.nqueens.NQueensSuccessorFunction;
import aima.search.uninformed.UniformCostSearch;
import java.util.List;
import junit.framework.TestCase;

public class UniformCostSearchTest
extends TestCase {
    public void testUniformCostSuccesfulSearch() throws Exception {
        Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
        UniformCostSearch search = new UniformCostSearch(new GraphSearch());
        SearchAgent agent = new SearchAgent(problem, search);
        List actions2 = agent.getActions();
        UniformCostSearchTest.assertEquals(8, actions2.size());
        UniformCostSearchTest.assertEquals("1965", agent.getInstrumentation().getProperty("nodesExpanded"));
        UniformCostSearchTest.assertEquals("8.0", agent.getInstrumentation().getProperty("pathCost"));
    }

    public void testUniformCostUnSuccesfulSearch() throws Exception {
        Problem problem = new Problem(new NQueensBoard(3), new NQueensSuccessorFunction(), new NQueensGoalTest());
        UniformCostSearch search = new UniformCostSearch(new GraphSearch());
        SearchAgent agent = new SearchAgent(problem, search);
        List actions2 = agent.getActions();
        UniformCostSearchTest.assertEquals(0, actions2.size());
        UniformCostSearchTest.assertEquals("6", agent.getInstrumentation().getProperty("nodesExpanded"));
        UniformCostSearchTest.assertEquals("0", agent.getInstrumentation().getProperty("pathCost"));
    }
}

