/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.online;

import aima.basic.BasicEnvironmentView;
import aima.search.map.BidirectionalMapProblem;
import aima.search.map.ExtendableMap;
import aima.search.map.MapEnvironment;
import aima.search.online.OnlineDFSAgent;
import junit.framework.TestCase;

public class OnlineDFSAgentTest
extends TestCase {
    ExtendableMap aMap;
    StringBuffer envChanges;

    @Override
    public void setUp() {
        this.aMap = new ExtendableMap();
        this.aMap.addBidirectionalLink("A", "B", 5.0);
        this.aMap.addBidirectionalLink("A", "C", 6.0);
        this.aMap.addBidirectionalLink("B", "D", 4.0);
        this.aMap.addBidirectionalLink("B", "E", 7.0);
        this.aMap.addBidirectionalLink("D", "F", 4.0);
        this.aMap.addBidirectionalLink("D", "G", 8.0);
        this.envChanges = new StringBuffer();
    }

    public void testAlreadyAtGoal() {
        MapEnvironment me = new MapEnvironment(this.aMap);
        OnlineDFSAgent agent = new OnlineDFSAgent(new BidirectionalMapProblem(me.getMap(), "A", "A"));
        me.addAgent(agent, "A");
        me.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                OnlineDFSAgentTest.this.envChanges.append(command).append("->");
            }
        });
        me.stepUntilDone();
        OnlineDFSAgentTest.assertEquals("NoOP->", this.envChanges.toString());
    }

    public void testNormalSearch() {
        MapEnvironment me = new MapEnvironment(this.aMap);
        OnlineDFSAgent agent = new OnlineDFSAgent(new BidirectionalMapProblem(me.getMap(), "A", "G"));
        me.addAgent(agent, "A");
        me.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                OnlineDFSAgentTest.this.envChanges.append(command).append("->");
            }
        });
        me.stepUntilDone();
        OnlineDFSAgentTest.assertEquals("C->A->B->E->B->D->G->NoOP->", this.envChanges.toString());
    }

    public void testNoPath() {
    }

    public void testFig4_18() {
        this.aMap = new ExtendableMap();
        this.aMap.addBidirectionalLink("1,1", "1,2", 1.0);
        this.aMap.addBidirectionalLink("1,1", "2,1", 1.0);
        this.aMap.addBidirectionalLink("1,2", "1,3", 1.0);
        this.aMap.addBidirectionalLink("1,2", "2,2", 1.0);
        this.aMap.addBidirectionalLink("1,3", "2,3", 1.0);
        this.aMap.addBidirectionalLink("2,2", "3,2", 1.0);
        this.aMap.addBidirectionalLink("2,3", "3,3", 1.0);
        this.aMap.addBidirectionalLink("3,1", "3,2", 1.0);
        MapEnvironment me = new MapEnvironment(this.aMap);
        OnlineDFSAgent agent = new OnlineDFSAgent(new BidirectionalMapProblem(me.getMap(), "1,1", "3,3"));
        me.addAgent(agent, "1,1");
        me.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                OnlineDFSAgentTest.this.envChanges.append(command).append("->");
            }
        });
        me.stepUntilDone();
        OnlineDFSAgentTest.assertEquals("2,1->1,1->1,2->2,2->3,2->3,1->3,2->2,2->1,2->1,3->2,3->3,3->NoOP->", this.envChanges.toString());
    }
}

