/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.visitors;

import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.visitors.CNFTransformer;
import junit.framework.TestCase;

public class CNFTransformerTest
extends TestCase {
    private PEParser parser = new PEParser();
    private CNFTransformer transformer;

    @Override
    public void setUp() {
        this.transformer = new CNFTransformer();
    }

    public void testSymbolTransform() {
        Sentence symbol = (Sentence)this.parser.parse("A");
        Sentence transformed = this.transformer.transform(symbol);
        CNFTransformerTest.assertEquals("A", transformed.toString());
    }

    public void testBasicSentenceTransformation() {
        Sentence and = (Sentence)this.parser.parse("(A AND B)");
        Sentence transformedAnd = this.transformer.transform(and);
        CNFTransformerTest.assertEquals(and.toString(), transformedAnd.toString());
        Sentence or = (Sentence)this.parser.parse("(A OR B)");
        Sentence transformedOr = this.transformer.transform(or);
        CNFTransformerTest.assertEquals(or.toString(), transformedOr.toString());
        Sentence not = (Sentence)this.parser.parse("(NOT C)");
        Sentence transformedNot = this.transformer.transform(not);
        CNFTransformerTest.assertEquals(not.toString(), transformedNot.toString());
    }

    public void testImplicationTransformation() {
        Sentence impl = (Sentence)this.parser.parse("(A => B)");
        Sentence expected = (Sentence)this.parser.parse("((NOT A) OR B)");
        Sentence transformedImpl = this.transformer.transform(impl);
        CNFTransformerTest.assertEquals(expected.toString(), transformedImpl.toString());
    }

    public void testBiConditionalTransformation() {
        Sentence bic = (Sentence)this.parser.parse("(A <=> B)");
        Sentence expected = (Sentence)this.parser.parse("(((NOT A) OR B)  AND ((NOT B) OR A)) ");
        Sentence transformedBic = this.transformer.transform(bic);
        CNFTransformerTest.assertEquals(expected.toString(), transformedBic.toString());
    }

    public void testTwoSuccessiveNotsTransformation() {
        Sentence twoNots = (Sentence)this.parser.parse("(NOT (NOT A))");
        Sentence expected = (Sentence)this.parser.parse("A");
        Sentence transformed = this.transformer.transform(twoNots);
        CNFTransformerTest.assertEquals(expected.toString(), transformed.toString());
    }

    public void testThreeSuccessiveNotsTransformation() {
        Sentence threeNots = (Sentence)this.parser.parse("(NOT (NOT (NOT A)))");
        Sentence expected = (Sentence)this.parser.parse("(NOT A)");
        Sentence transformed = this.transformer.transform(threeNots);
        CNFTransformerTest.assertEquals(expected.toString(), transformed.toString());
    }

    public void testFourSuccessiveNotsTransformation() {
        Sentence fourNots = (Sentence)this.parser.parse("(NOT (NOT (NOT (NOT A))))");
        Sentence expected = (Sentence)this.parser.parse("A");
        Sentence transformed = this.transformer.transform(fourNots);
        CNFTransformerTest.assertEquals(expected.toString(), transformed.toString());
    }

    public void testDeMorgan1() {
        Sentence dm = (Sentence)this.parser.parse("(NOT (A AND B))");
        Sentence expected = (Sentence)this.parser.parse("((NOT A) OR (NOT B))");
        Sentence transformed = this.transformer.transform(dm);
        CNFTransformerTest.assertEquals(expected.toString(), transformed.toString());
    }

    public void testDeMorgan2() {
        Sentence dm = (Sentence)this.parser.parse("(NOT (A OR B))");
        Sentence expected = (Sentence)this.parser.parse("((NOT A) AND (NOT B))");
        Sentence transformed = this.transformer.transform(dm);
        CNFTransformerTest.assertEquals(expected.toString(), transformed.toString());
    }

    public void testOrDistribution1() {
        Sentence or = (Sentence)this.parser.parse("((A AND B) OR C)");
        Sentence expected = (Sentence)this.parser.parse("((C OR A) AND (C OR B))");
        Sentence transformed = this.transformer.transform(or);
        CNFTransformerTest.assertEquals(expected.toString(), transformed.toString());
    }

    public void testOrDistribution2() {
        Sentence or = (Sentence)this.parser.parse("(A OR (B AND C))");
        Sentence expected = (Sentence)this.parser.parse("((A OR B) AND (A OR C))");
        Sentence transformed = this.transformer.transform(or);
        CNFTransformerTest.assertEquals(expected.toString(), transformed.toString());
    }

    public void testAimaExample() {
        Sentence aimaEg = (Sentence)this.parser.parse("( B11 <=> (P12 OR P21))");
        Sentence expected = (Sentence)this.parser.parse(" (  (  ( NOT B11 )  OR  ( P12 OR P21 ) ) AND  (  ( B11 OR  ( NOT P12 )  ) AND  ( B11 OR  ( NOT P21 )  ) ) )");
        Sentence transformed = this.transformer.transform(aimaEg);
        CNFTransformerTest.assertEquals(expected.toString(), transformed.toString());
    }
}

