/*
 * Decompiled with CFR 0.152.
 */
package aima.test.learningtest.neural;

import aima.learning.framework.DataSet;
import aima.learning.framework.DataSetFactory;
import aima.learning.neural.BackPropLearning;
import aima.learning.neural.FeedForwardNeuralNetwork;
import aima.learning.neural.IrisDataSetNumerizer;
import aima.learning.neural.IrisNNDataSet;
import aima.learning.neural.NNConfig;
import aima.learning.neural.Perceptron;
import aima.learning.neural.Vector;
import aima.util.Matrix;
import junit.framework.TestCase;

public class BackPropagationTests
extends TestCase {
    public void testFeedForwardAndBAckLoopWorks() {
        Matrix hiddenLayerWeightMatrix = new Matrix(2, 1);
        hiddenLayerWeightMatrix.set(0, 0, -0.27);
        hiddenLayerWeightMatrix.set(1, 0, -0.41);
        Vector hiddenLayerBiasVector = new Vector(2);
        hiddenLayerBiasVector.setValue(0, -0.48);
        hiddenLayerBiasVector.setValue(1, -0.13);
        Vector input = new Vector(1);
        input.setValue(0, 1.0);
        Matrix outputLayerWeightMatrix = new Matrix(1, 2);
        outputLayerWeightMatrix.set(0, 0, 0.09);
        outputLayerWeightMatrix.set(0, 1, -0.17);
        Vector outputLayerBiasVector = new Vector(1);
        outputLayerBiasVector.setValue(0, 0.48);
        Vector error = new Vector(1);
        error.setValue(0, 1.261);
        double learningRate = 0.1;
        double momentumFactor = 0.0;
        FeedForwardNeuralNetwork ffnn = new FeedForwardNeuralNetwork(hiddenLayerWeightMatrix, hiddenLayerBiasVector, outputLayerWeightMatrix, outputLayerBiasVector);
        ffnn.setTrainingScheme(new BackPropLearning(learningRate, momentumFactor));
        ffnn.processInput(input);
        ffnn.processError(error);
        Matrix finalHiddenLayerWeights = ffnn.getHiddenLayerWeights();
        BackPropagationTests.assertEquals(-0.265, finalHiddenLayerWeights.get(0, 0), 0.001);
        BackPropagationTests.assertEquals(-0.419, finalHiddenLayerWeights.get(1, 0), 0.001);
        Vector hiddenLayerBias = ffnn.getHiddenLayerBias();
        BackPropagationTests.assertEquals(-0.475, hiddenLayerBias.getValue(0), 0.001);
        BackPropagationTests.assertEquals(-0.1399, hiddenLayerBias.getValue(1), 0.001);
        Matrix finalOutputLayerWeights = ffnn.getOutputLayerWeights();
        BackPropagationTests.assertEquals(0.171, finalOutputLayerWeights.get(0, 0), 0.001);
        BackPropagationTests.assertEquals(-0.0772, finalOutputLayerWeights.get(0, 1), 0.001);
        Vector outputLayerBias = ffnn.getOutputLayerBias();
        BackPropagationTests.assertEquals(0.7322, outputLayerBias.getValue(0), 0.001);
    }

    public void xtestFeedForwardAndBAckLoopWorksWithMomentum() {
        Matrix hiddenLayerWeightMatrix = new Matrix(2, 1);
        hiddenLayerWeightMatrix.set(0, 0, -0.27);
        hiddenLayerWeightMatrix.set(1, 0, -0.41);
        Vector hiddenLayerBiasVector = new Vector(2);
        hiddenLayerBiasVector.setValue(0, -0.48);
        hiddenLayerBiasVector.setValue(1, -0.13);
        Vector input = new Vector(1);
        input.setValue(0, 1.0);
        Matrix outputLayerWeightMatrix = new Matrix(1, 2);
        outputLayerWeightMatrix.set(0, 0, 0.09);
        outputLayerWeightMatrix.set(0, 1, -0.17);
        Vector outputLayerBiasVector = new Vector(1);
        outputLayerBiasVector.setValue(0, 0.48);
        Vector error = new Vector(1);
        error.setValue(0, 1.261);
        double learningRate = 0.1;
        double momentumFactor = 0.5;
        FeedForwardNeuralNetwork ffnn = new FeedForwardNeuralNetwork(hiddenLayerWeightMatrix, hiddenLayerBiasVector, outputLayerWeightMatrix, outputLayerBiasVector);
        ffnn.setTrainingScheme(new BackPropLearning(learningRate, momentumFactor));
        ffnn.processInput(input);
        ffnn.processError(error);
        Matrix finalHiddenLayerWeights = ffnn.getHiddenLayerWeights();
        BackPropagationTests.assertEquals(-0.2675, finalHiddenLayerWeights.get(0, 0), 0.001);
        BackPropagationTests.assertEquals(-0.4149, finalHiddenLayerWeights.get(1, 0), 0.001);
        Vector hiddenLayerBias = ffnn.getHiddenLayerBias();
        BackPropagationTests.assertEquals(-0.4775, hiddenLayerBias.getValue(0), 0.001);
        BackPropagationTests.assertEquals(-0.1349, hiddenLayerBias.getValue(1), 0.001);
        Matrix finalOutputLayerWeights = ffnn.getOutputLayerWeights();
        BackPropagationTests.assertEquals(0.1304, finalOutputLayerWeights.get(0, 0), 0.001);
        BackPropagationTests.assertEquals(-0.1235, finalOutputLayerWeights.get(0, 1), 0.001);
        Vector outputLayerBias = ffnn.getOutputLayerBias();
        BackPropagationTests.assertEquals(0.6061, outputLayerBias.getValue(0), 0.001);
    }

    public void xtestDataSetPopulation() throws Exception {
        DataSet irisDataSet = DataSetFactory.getIrisDataSet();
        IrisDataSetNumerizer numerizer = new IrisDataSetNumerizer();
        IrisNNDataSet innds = new IrisNNDataSet();
        innds.createExamplesFromDataSet(irisDataSet, numerizer);
        NNConfig config = new NNConfig();
        config.setConfig("number_of_inputs", 4);
        config.setConfig("number_of_outputs", 3);
        config.setConfig("number_of_hidden_neurons", 6);
        config.setConfig("lower_limit_weights", -2.0);
        config.setConfig("upper_limit_weights", 2.0);
        FeedForwardNeuralNetwork ffnn = new FeedForwardNeuralNetwork(config);
        ffnn.setTrainingScheme(new BackPropLearning(0.1, 0.9));
        ffnn.trainOn(innds, 10);
        innds.refreshDataset();
        int[] result = ffnn.testOnDataSet(innds);
    }

    public void testPerceptron() throws Exception {
        DataSet irisDataSet = DataSetFactory.getIrisDataSet();
        IrisDataSetNumerizer numerizer = new IrisDataSetNumerizer();
        IrisNNDataSet innds = new IrisNNDataSet();
        innds.createExamplesFromDataSet(irisDataSet, numerizer);
        Perceptron perc = new Perceptron(3, 4);
        perc.trainOn(innds, 10);
        innds.refreshDataset();
        int[] result = perc.testOnDataSet(innds);
    }
}

