/*
 * Decompiled with CFR 0.152.
 */
package aima.test.gametest;

import aima.games.AlphaBeta;
import aima.games.GameState;
import aima.games.TicTacToe;
import aima.games.TicTacToeBoard;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TicTacToeTest
extends TestCase {
    private TicTacToeBoard tb;

    public TicTacToeTest(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        this.tb = new TicTacToeBoard();
    }

    public void testCreation() {
        TicTacToe t3 = new TicTacToe();
        TicTacToeTest.assertEquals(9, t3.getMoves(t3.getState()).size());
        TicTacToeTest.assertEquals("X", t3.getPlayerToMove(t3.getState()));
    }

    public void testOnCreationBoardIsEmpty() {
        TicTacToeTest.assertEquals(true, this.tb.isEmpty(0, 0));
        TicTacToeTest.assertEquals(true, this.tb.isEmpty(0, 2));
        TicTacToeTest.assertEquals(true, this.tb.isEmpty(2, 0));
        TicTacToeTest.assertEquals(true, this.tb.isEmpty(2, 2));
    }

    public void testMovingBumpsLevelByOne() {
        TicTacToe t1 = new TicTacToe();
        int level = t1.getLevel(t1.getState());
        TicTacToeTest.assertEquals(0, level);
        t1.makeMove(0, 0);
        level = t1.getLevel(t1.getState());
        TicTacToeTest.assertEquals(1, level);
    }

    public void testMarkingAsSquareMakesItNonEmpty() {
        this.tb.markX(0, 0);
        TicTacToeTest.assertEquals(false, this.tb.isEmpty(0, 0));
    }

    public void testAllCombinationsOfSuccessLines() {
        this.tb.markX(0, 0);
        this.tb.markX(0, 1);
        this.tb.markX(0, 2);
        TicTacToeTest.assertEquals(true, this.tb.isAnyRowComplete());
        this.tb.markO(0, 2);
        TicTacToeTest.assertEquals(false, this.tb.isAnyRowComplete());
        this.tb.markO(1, 2);
        this.tb.markO(2, 2);
        TicTacToeTest.assertEquals(true, this.tb.isAnyColumnComplete());
        this.tb.markX(2, 2);
        this.tb.markX(1, 1);
        TicTacToeTest.assertEquals(true, this.tb.isAnyDiagonalComplete());
        this.tb.markO(1, 1);
        this.tb.markO(2, 0);
        TicTacToeTest.assertEquals(true, this.tb.isAnyDiagonalComplete());
    }

    public void testGivenABoardNUmberOfPossibleMovesCalculatedCorrectly() {
        TicTacToe t3 = new TicTacToe();
        TicTacToeTest.assertEquals(9, t3.getMoves(t3.getState()).size());
        TicTacToeTest.assertEquals("X", t3.getPlayerToMove(t3.getState()));
        t3.makeMove(t3.getState(), 0, 0);
        TicTacToeTest.assertEquals(8, t3.getMoves(t3.getState()).size());
        TicTacToeTest.assertEquals("O", t3.getPlayerToMove(t3.getState()));
        t3.makeMove(t3.getState(), 0, 0);
        TicTacToeTest.assertEquals(8, t3.getMoves(t3.getState()).size());
        TicTacToeTest.assertEquals("O", t3.getPlayerToMove(t3.getState()));
        t3.makeMove(t3.getState(), 1, 1);
        TicTacToeTest.assertEquals(7, t3.getMoves(t3.getState()).size());
        TicTacToeTest.assertEquals("X", t3.getPlayerToMove(t3.getState()));
    }

    public void testCalculateUtilityOfABoard() {
        TicTacToe t3 = new TicTacToe();
        t3.makeMove(t3.getState(), 0, 0);
        TicTacToeTest.assertEquals(0, t3.getUtility(t3.getState()));
        t3.makeMove(t3.getState(), 2, 2);
        TicTacToeTest.assertEquals(0, t3.getUtility(t3.getState()));
        t3.makeMove(t3.getState(), 2, 0);
        TicTacToeTest.assertEquals(0, t3.getUtility(t3.getState()));
        t3.makeMove(t3.getState(), 1, 0);
        TicTacToeTest.assertEquals(0, t3.getUtility(t3.getState()));
        t3.makeMove(t3.getState(), 0, 2);
        TicTacToeTest.assertEquals(0, t3.getUtility(t3.getState()));
        t3.makeMove(t3.getState(), 0, 1);
        TicTacToeTest.assertEquals(0, t3.getUtility(t3.getState()));
        t3.makeMove(t3.getState(), 1, 1);
        TicTacToeTest.assertEquals(1, t3.computeUtility(t3.getState()));
        TicTacToe t4 = new TicTacToe();
        t4.makeMove(t4.getState(), 0, 0);
        TicTacToeTest.assertEquals(0, t4.getUtility(t4.getState()));
        t4.makeMove(t4.getState(), 0, 1);
        TicTacToeTest.assertEquals(0, t4.getUtility(t4.getState()));
        t4.makeMove(t4.getState(), 0, 2);
        TicTacToeTest.assertEquals(0, t4.getUtility(t4.getState()));
        t4.makeMove(t4.getState(), 1, 0);
        TicTacToeTest.assertEquals(0, t4.getUtility(t4.getState()));
        t4.makeMove(t4.getState(), 1, 1);
        TicTacToeTest.assertEquals(0, t4.getUtility(t4.getState()));
        t4.makeMove(t4.getState(), 1, 2);
        TicTacToeTest.assertEquals(0, t4.getUtility(t4.getState()));
        t4.makeMove(t4.getState(), 2, 0);
        TicTacToeTest.assertEquals(1, t4.computeUtility(t4.getState()));
    }

    public void testGenerateSuccessors() {
        TicTacToe t3 = new TicTacToe();
        ArrayList successors = t3.getSuccessorStates(t3.getState());
        TicTacToeTest.assertEquals(9, successors.size());
        this.checkSuccessorList(successors, "O", 8);
        ArrayList successors2 = t3.getSuccessorStates((GameState)successors.get(0));
        this.checkSuccessorList(successors2, "X", 7);
        ArrayList successors3 = t3.getSuccessorStates((GameState)successors2.get(0));
        this.checkSuccessorList(successors3, "O", 6);
    }

    public void testGameStateEquality() {
        TicTacToeBoard tb1 = new TicTacToeBoard();
        TicTacToeBoard tb2 = new TicTacToeBoard();
        GameState gs1 = new GameState();
        GameState gs2 = new GameState();
        gs1.put("board", tb1);
        gs2.put("board", tb2);
        TicTacToeTest.assertEquals(gs1, gs2);
        gs1.put("minimaxValue", new Integer(3));
        TicTacToeTest.assertTrue(!gs1.equals(gs2));
    }

    public void testMiniMax() {
        TicTacToe t3 = new TicTacToe();
        t3.makeMove(0, 0);
        t3.makeMove(2, 2);
        t3.makeMove(2, 0);
        t3.makeMove(1, 1);
        TicTacToeTest.assertEquals(1, t3.getMiniMaxValue(t3.getState()));
    }

    public void testMiniMax2() {
        TicTacToe t3 = new TicTacToe();
        t3.makeMove(0, 0);
        t3.makeMove(2, 2);
        t3.makeMove(2, 0);
        TicTacToeTest.assertEquals(1, t3.getMiniMaxValue(t3.getState()));
    }

    public void testMiniMax3() {
        TicTacToe t3 = new TicTacToe();
        t3.makeMove(0, 0);
        t3.makeMove(1, 1);
        TicTacToeTest.assertEquals(0, t3.getMiniMaxValue(t3.getState()));
    }

    public void testMiniMax7() {
        TicTacToe t3 = new TicTacToe();
        t3.makeMove(0, 0);
        t3.makeMove(0, 1);
        TicTacToeTest.assertEquals(1, t3.getMiniMaxValue(t3.getState()));
    }

    public void tesMiniMax4() {
        TicTacToe t3 = new TicTacToe();
        TicTacToeTest.assertEquals(0, t3.getMiniMaxValue(t3.getState()));
    }

    public void testTerminalStateDetection() {
        TicTacToe t3 = new TicTacToe();
        t3.makeMove(0, 0);
        t3.makeMove(0, 1);
        t3.makeMove(0, 2);
        t3.makeMove(1, 0);
        t3.makeMove(1, 1);
        t3.makeMove(1, 2);
        TicTacToeTest.assertEquals(1, t3.getMiniMaxValue(t3.getState()));
    }

    public void testMiniMax15() {
        TicTacToe t1 = new TicTacToe();
        t1.makeMove(0, 0);
        int minimax1 = t1.getMiniMaxValue(t1.getState());
        TicTacToe t2 = new TicTacToe();
        t2.makeMove(0, 2);
        int minimax2 = t2.getMiniMaxValue(t2.getState());
        TicTacToe t3 = new TicTacToe();
        t3.makeMove(2, 0);
        int minimax3 = t3.getMiniMaxValue(t3.getState());
        TicTacToe t4 = new TicTacToe();
        int minimax4 = t4.getMiniMaxValue(t4.getState());
        t4.makeMove(2, 2);
        TicTacToeTest.assertEquals(minimax1, minimax2);
    }

    public void testMiniMax6() {
        TicTacToe t3 = new TicTacToe();
        t3.makeMove(0, 0);
        t3.makeMove(0, 1);
        t3.makeMove(0, 2);
        t3.makeMove(2, 2);
        t3.makeMove(1, 2);
        t3.makeMove(2, 1);
        t3.makeMove(1, 1);
        TicTacToeTest.assertEquals(-1, t3.getMiniMaxValue(t3.getState()));
    }

    public void testAlphaBeta() {
        TicTacToe t1 = new TicTacToe();
        int alphabeta0 = t1.getAlphaBetaValue(t1.getState());
        TicTacToeTest.assertEquals(0, alphabeta0);
        t1.makeMove(0, 0);
        int alphabeta1 = t1.getAlphaBetaValue(t1.getState());
        TicTacToeTest.assertEquals(0, alphabeta1);
        TicTacToe t2 = new TicTacToe();
        t2.makeMove(0, 2);
        int alphabeta2 = t2.getAlphaBetaValue(t2.getState());
        TicTacToeTest.assertEquals(0, alphabeta2);
        TicTacToe t3 = new TicTacToe();
        t3.makeMove(2, 0);
        int alphabeta3 = t3.getAlphaBetaValue(t3.getState());
        TicTacToeTest.assertEquals(0, alphabeta3);
        TicTacToe t4 = new TicTacToe();
        int alphabeta4 = t4.getAlphaBetaValue(t4.getState());
        t4.makeMove(2, 2);
        TicTacToeTest.assertEquals(0, alphabeta4);
    }

    private void checkSuccessorList(ArrayList successorList, String playerToMove, int sizeOfSuccessors) {
        for (int i = 0; i < successorList.size(); ++i) {
            GameState h = (GameState)successorList.get(i);
            ArrayList successors2 = new TicTacToe().getSuccessorStates(h);
            TicTacToeTest.assertEquals(sizeOfSuccessors, successors2.size());
            TicTacToeTest.assertEquals(playerToMove, new TicTacToe().getPlayerToMove(h));
        }
    }

    public void testAlphaBetaMinValueCalculation() {
        TicTacToe t = new TicTacToe();
        t.makeMove(0, 0);
        t.makeMove(0, 1);
        t.makeMove(0, 2);
        t.makeMove(1, 0);
        t.makeMove(1, 2);
        t.makeMove(1, 1);
        t.makeMove(2, 1);
        int minValue = t.minValue(t.getState(), new AlphaBeta(Integer.MIN_VALUE, Integer.MAX_VALUE));
        TicTacToeTest.assertEquals(0, minValue);
    }
}

