/*
 * Decompiled with CFR 0.152.
 */
package aima.search.demos;

import aima.search.framework.GoalTest;
import aima.search.framework.GraphSearch;
import aima.search.framework.Problem;
import aima.search.framework.SearchAgent;
import aima.search.framework.SuccessorFunction;
import aima.search.framework.TreeSearch;
import aima.search.informed.HillClimbingSearch;
import aima.search.informed.SimulatedAnnealingSearch;
import aima.search.informed.ga.FitnessFunction;
import aima.search.informed.ga.GeneticAlgorithm;
import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensFitnessFunction;
import aima.search.nqueens.NQueensGoalTest;
import aima.search.nqueens.NQueensSuccessorFunction;
import aima.search.nqueens.QueensToBePlacedHeuristic;
import aima.search.uninformed.BreadthFirstSearch;
import aima.search.uninformed.DepthFirstSearch;
import aima.search.uninformed.DepthLimitedSearch;
import aima.search.uninformed.IterativeDeepeningSearch;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class NQueensDemo {
    public static void main(String[] args) {
        NQueensDemo.newNQueensDemo();
    }

    private static void newNQueensDemo() {
        NQueensDemo.nQueensWithDepthFirstSearch();
        NQueensDemo.nQueensWithBreadthFirstSearch();
        NQueensDemo.nQueensWithRecursiveDLS();
        NQueensDemo.nQueensWithIterativeDeepeningSearch();
        NQueensDemo.nQueensSimulatedAnnealingSearch();
        NQueensDemo.nQueensHillClimbingSearch();
        NQueensDemo.nQueensGeneticAlgorithmSearch();
    }

    private static void nQueensWithRecursiveDLS() {
        System.out.println("\nNQueensDemo recursive DLS -->");
        try {
            Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
            DepthLimitedSearch search = new DepthLimitedSearch(8);
            SearchAgent agent = new SearchAgent(problem, search);
            NQueensDemo.printActions(agent.getActions());
            NQueensDemo.printInstrumentation(agent.getInstrumentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void nQueensWithBreadthFirstSearch() {
        try {
            System.out.println("\nNQueensDemo BFS -->");
            Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
            BreadthFirstSearch search = new BreadthFirstSearch(new TreeSearch());
            SearchAgent agent2 = new SearchAgent(problem, search);
            NQueensDemo.printActions(agent2.getActions());
            NQueensDemo.printInstrumentation(agent2.getInstrumentation());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private static void nQueensWithDepthFirstSearch() {
        System.out.println("\nNQueensDemo DFS -->");
        try {
            Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
            DepthFirstSearch search = new DepthFirstSearch(new GraphSearch());
            SearchAgent agent = new SearchAgent(problem, search);
            NQueensDemo.printActions(agent.getActions());
            NQueensDemo.printInstrumentation(agent.getInstrumentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void nQueensWithIterativeDeepeningSearch() {
        System.out.println("\nNQueensDemo Iterative DS  -->");
        try {
            Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
            IterativeDeepeningSearch search = new IterativeDeepeningSearch();
            SearchAgent agent = new SearchAgent(problem, search);
            System.out.println();
            NQueensDemo.printActions(agent.getActions());
            NQueensDemo.printInstrumentation(agent.getInstrumentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void nQueensSimulatedAnnealingSearch() {
        System.out.println("\nNQueensDemo Simulated Annealing  -->");
        try {
            Problem problem = new Problem((Object)new NQueensBoard(8), (SuccessorFunction)new NQueensSuccessorFunction(), (GoalTest)new NQueensGoalTest(), new QueensToBePlacedHeuristic());
            SimulatedAnnealingSearch search = new SimulatedAnnealingSearch();
            SearchAgent agent = new SearchAgent(problem, search);
            System.out.println();
            NQueensDemo.printActions(agent.getActions());
            System.out.println("Search Outcome=" + (Object)((Object)search.getOutcome()));
            System.out.println("Final State=\n" + search.getLastSearchState());
            NQueensDemo.printInstrumentation(agent.getInstrumentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void nQueensHillClimbingSearch() {
        System.out.println("\nNQueensDemo HillClimbing  -->");
        try {
            Problem problem = new Problem((Object)new NQueensBoard(8), (SuccessorFunction)new NQueensSuccessorFunction(), (GoalTest)new NQueensGoalTest(), new QueensToBePlacedHeuristic());
            HillClimbingSearch search = new HillClimbingSearch();
            SearchAgent agent = new SearchAgent(problem, search);
            System.out.println();
            NQueensDemo.printActions(agent.getActions());
            System.out.println("Search Outcome=" + (Object)((Object)search.getOutcome()));
            System.out.println("Final State=\n" + search.getLastSearchState());
            NQueensDemo.printInstrumentation(agent.getInstrumentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void nQueensGeneticAlgorithmSearch() {
        System.out.println("\nNQueensDemo GeneticAlgorithm  -->");
        try {
            int boardSize = 8;
            NQueensFitnessFunction fitnessFunction = new NQueensFitnessFunction();
            HashSet<String> population = new HashSet<String>();
            for (int i = 0; i < 20; ++i) {
                population.add(fitnessFunction.generateRandomIndividual(boardSize));
            }
            GeneticAlgorithm ga = new GeneticAlgorithm(boardSize, fitnessFunction.getFiniteAlphabetForBoardOfSize(boardSize), 0.15);
            String bestIndividual = ga.geneticAlgorithm(population, (FitnessFunction)fitnessFunction, 100);
            System.out.println("Iterations Best Individual=\n" + fitnessFunction.getBoardForIndividual(bestIndividual));
            System.out.println("Fitness=" + fitnessFunction.getValue(bestIndividual));
            System.out.println("Is Goal=" + fitnessFunction.isGoalState(bestIndividual));
            System.out.println("Itertions=" + ga.getIterations());
            bestIndividual = ga.geneticAlgorithm(population, (FitnessFunction)fitnessFunction, fitnessFunction);
            System.out.println("Goal Test Best Individual=\n" + fitnessFunction.getBoardForIndividual(bestIndividual));
            System.out.println("Fitness=" + fitnessFunction.getValue(bestIndividual));
            System.out.println("Is Goal=" + fitnessFunction.isGoalState(bestIndividual));
            System.out.println("Itertions=" + ga.getIterations());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printInstrumentation(Properties properties) {
        for (String string : properties.keySet()) {
            String property = properties.getProperty(string);
            System.out.println(string + " : " + property);
        }
    }

    private static void printActions(List actions2) {
        for (int i = 0; i < actions2.size(); ++i) {
            String action = (String)actions2.get(i);
            System.out.println(action);
        }
    }
}

