/*
 * Decompiled with CFR 0.152.
 */
package aima.search.demos;

import aima.search.eightpuzzle.EightPuzzleBoard;
import aima.search.eightpuzzle.EightPuzzleGoalTest;
import aima.search.eightpuzzle.EightPuzzleSuccessorFunction;
import aima.search.eightpuzzle.ManhattanHeuristicFunction;
import aima.search.eightpuzzle.MisplacedTilleHeuristicFunction;
import aima.search.framework.GoalTest;
import aima.search.framework.GraphSearch;
import aima.search.framework.Problem;
import aima.search.framework.SearchAgent;
import aima.search.framework.SuccessorFunction;
import aima.search.informed.AStarSearch;
import aima.search.informed.GreedyBestFirstSearch;
import aima.search.informed.SimulatedAnnealingSearch;
import aima.search.uninformed.DepthLimitedSearch;
import aima.search.uninformed.IterativeDeepeningSearch;
import java.util.List;
import java.util.Properties;

public class EightPuzzleDemo {
    static EightPuzzleBoard boardWithThreeMoveSolution = new EightPuzzleBoard(new int[]{1, 2, 5, 3, 4, 0, 6, 7, 8});
    static EightPuzzleBoard random1 = new EightPuzzleBoard(new int[]{1, 4, 2, 7, 5, 8, 3, 0, 6});
    static EightPuzzleBoard extreme = new EightPuzzleBoard(new int[]{0, 8, 7, 6, 5, 4, 3, 2, 1});

    public static void main(String[] args) {
        EightPuzzleDemo.eightPuzzleDLSDemo();
        EightPuzzleDemo.eightPuzzleIDLSDemo();
        EightPuzzleDemo.eightPuzzleGreedyBestFirstDemo();
        EightPuzzleDemo.eightPuzzleGreedyBestFirstManhattanDemo();
        EightPuzzleDemo.eightPuzzleAStarDemo();
        EightPuzzleDemo.eightPuzzleAStarManhattanDemo();
        EightPuzzleDemo.eightPuzzleSimulatedAnnealingDemo();
    }

    private static void eightPuzzleDLSDemo() {
        System.out.println("\nEightPuzzleDemo recursive DLS -->");
        try {
            Problem problem = new Problem(random1, new EightPuzzleSuccessorFunction(), new EightPuzzleGoalTest());
            DepthLimitedSearch search = new DepthLimitedSearch(9);
            SearchAgent agent = new SearchAgent(problem, search);
            EightPuzzleDemo.printActions(agent.getActions());
            EightPuzzleDemo.printInstrumentation(agent.getInstrumentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void eightPuzzleIDLSDemo() {
        System.out.println("\nEightPuzzleDemo Iterative DLS -->");
        try {
            Problem problem = new Problem(random1, new EightPuzzleSuccessorFunction(), new EightPuzzleGoalTest());
            IterativeDeepeningSearch search = new IterativeDeepeningSearch();
            SearchAgent agent = new SearchAgent(problem, search);
            EightPuzzleDemo.printActions(agent.getActions());
            EightPuzzleDemo.printInstrumentation(agent.getInstrumentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void eightPuzzleGreedyBestFirstDemo() {
        System.out.println("\nEightPuzzleDemo Greedy Best First Search (MisplacedTileHeursitic)-->");
        try {
            Problem problem = new Problem((Object)boardWithThreeMoveSolution, (SuccessorFunction)new EightPuzzleSuccessorFunction(), (GoalTest)new EightPuzzleGoalTest(), new MisplacedTilleHeuristicFunction());
            GreedyBestFirstSearch search = new GreedyBestFirstSearch(new GraphSearch());
            SearchAgent agent = new SearchAgent(problem, search);
            EightPuzzleDemo.printActions(agent.getActions());
            EightPuzzleDemo.printInstrumentation(agent.getInstrumentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void eightPuzzleGreedyBestFirstManhattanDemo() {
        System.out.println("\nEightPuzzleDemo Greedy Best First Search (ManhattanHeursitic)-->");
        try {
            Problem problem = new Problem((Object)boardWithThreeMoveSolution, (SuccessorFunction)new EightPuzzleSuccessorFunction(), (GoalTest)new EightPuzzleGoalTest(), new ManhattanHeuristicFunction());
            GreedyBestFirstSearch search = new GreedyBestFirstSearch(new GraphSearch());
            SearchAgent agent = new SearchAgent(problem, search);
            EightPuzzleDemo.printActions(agent.getActions());
            EightPuzzleDemo.printInstrumentation(agent.getInstrumentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void eightPuzzleAStarDemo() {
        System.out.println("\nEightPuzzleDemo AStar Search (MisplacedTileHeursitic)-->");
        try {
            Problem problem = new Problem((Object)random1, (SuccessorFunction)new EightPuzzleSuccessorFunction(), (GoalTest)new EightPuzzleGoalTest(), new MisplacedTilleHeuristicFunction());
            AStarSearch search = new AStarSearch(new GraphSearch());
            SearchAgent agent = new SearchAgent(problem, search);
            EightPuzzleDemo.printActions(agent.getActions());
            EightPuzzleDemo.printInstrumentation(agent.getInstrumentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void eightPuzzleSimulatedAnnealingDemo() {
        System.out.println("\nEightPuzzleDemo Simulated Annealing  Search -->");
        try {
            Problem problem = new Problem((Object)random1, (SuccessorFunction)new EightPuzzleSuccessorFunction(), (GoalTest)new EightPuzzleGoalTest(), new ManhattanHeuristicFunction());
            SimulatedAnnealingSearch search = new SimulatedAnnealingSearch();
            SearchAgent agent = new SearchAgent(problem, search);
            EightPuzzleDemo.printActions(agent.getActions());
            System.out.println("Search Outcome=" + (Object)((Object)search.getOutcome()));
            System.out.println("Final State=\n" + search.getLastSearchState());
            EightPuzzleDemo.printInstrumentation(agent.getInstrumentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void eightPuzzleAStarManhattanDemo() {
        System.out.println("\nEightPuzzleDemo AStar Search (ManhattanHeursitic)-->");
        try {
            Problem problem = new Problem((Object)random1, (SuccessorFunction)new EightPuzzleSuccessorFunction(), (GoalTest)new EightPuzzleGoalTest(), new ManhattanHeuristicFunction());
            AStarSearch search = new AStarSearch(new GraphSearch());
            SearchAgent agent = new SearchAgent(problem, search);
            EightPuzzleDemo.printActions(agent.getActions());
            EightPuzzleDemo.printInstrumentation(agent.getInstrumentation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printInstrumentation(Properties properties) {
        for (String string : properties.keySet()) {
            String property = properties.getProperty(string);
            System.out.println(string + " : " + property);
        }
    }

    private static void printActions(List actions2) {
        for (int i = 0; i < actions2.size(); ++i) {
            String action = (String)actions2.get(i);
            System.out.println(action);
        }
    }
}

