/*
 * Decompiled with CFR 0.152.
 */
package aima.probability;

import aima.probability.BayesNetNode;
import aima.probability.JavaRandomizer;
import aima.probability.Randomizer;
import aima.util.Util;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class BayesNet {
    private List<BayesNetNode> roots = new ArrayList<BayesNetNode>();
    private List<BayesNetNode> variableNodes;

    public BayesNet(BayesNetNode root) {
        this.roots.add(root);
    }

    public BayesNet(BayesNetNode root1, BayesNetNode root2) {
        this(root1);
        this.roots.add(root2);
    }

    public BayesNet(BayesNetNode root1, BayesNetNode root2, BayesNetNode root3) {
        this(root1, root2);
        this.roots.add(root3);
    }

    public BayesNet(List<BayesNetNode> rootNodes) {
        this.roots = rootNodes;
    }

    public List<String> getVariables() {
        this.variableNodes = this.getVariableNodes();
        ArrayList<String> variables = new ArrayList<String>();
        for (BayesNetNode variableNode : this.variableNodes) {
            variables.add(variableNode.getVariable());
        }
        return variables;
    }

    private List<BayesNetNode> getVariableNodes() {
        if (this.variableNodes == null) {
            ArrayList<BayesNetNode> newVariableNodes = new ArrayList<BayesNetNode>();
            List<BayesNetNode> parents = this.roots;
            ArrayList<BayesNetNode> traversedParents = new ArrayList<BayesNetNode>();
            while (parents.size() != 0) {
                ArrayList<BayesNetNode> newParents = new ArrayList<BayesNetNode>();
                for (BayesNetNode parent : parents) {
                    if (traversedParents.contains(parent)) continue;
                    newVariableNodes.add(parent);
                    List<BayesNetNode> children = parent.getChildren();
                    for (BayesNetNode child : children) {
                        if (newParents.contains(child)) continue;
                        newParents.add(child);
                    }
                    traversedParents.add(parent);
                }
                parents = newParents;
            }
            this.variableNodes = newVariableNodes;
        }
        return this.variableNodes;
    }

    private BayesNetNode getNodeOf(String y) {
        List<BayesNetNode> variableNodes = this.getVariableNodes();
        for (BayesNetNode node : variableNodes) {
            if (!node.getVariable().equals(y)) continue;
            return node;
        }
        return null;
    }

    public double probabilityOf(String Y, Boolean value, Hashtable<String, Boolean> evidence) {
        BayesNetNode y = this.getNodeOf(Y);
        if (y == null) {
            throw new RuntimeException("Unable to find a node with variable " + Y);
        }
        List<BayesNetNode> parentNodes = y.getParents();
        if (parentNodes.size() == 0) {
            Hashtable<String, Boolean> YTable = new Hashtable<String, Boolean>();
            YTable.put(Y, value);
            double prob = y.probabilityOf(YTable);
            return prob;
        }
        Hashtable<String, Boolean> parentValues = new Hashtable<String, Boolean>();
        for (BayesNetNode parent : parentNodes) {
            parentValues.put(parent.getVariable(), evidence.get(parent.getVariable()));
        }
        double prob = y.probabilityOf(parentValues);
        if (value.equals(Boolean.TRUE)) {
            return prob;
        }
        return 1.0 - prob;
    }

    public Hashtable getPriorSample(Randomizer r) {
        Hashtable<String, Boolean> h = new Hashtable<String, Boolean>();
        List<BayesNetNode> variableNodes = this.getVariableNodes();
        for (BayesNetNode node : variableNodes) {
            h.put(node.getVariable(), node.isTrueFor(r.nextDouble(), h));
        }
        return h;
    }

    public Hashtable getPriorSample() {
        return this.getPriorSample(new JavaRandomizer());
    }

    public double[] rejectionSample(String X, Hashtable evidence, int numberOfSamples, Randomizer r) {
        double[] retval = new double[2];
        for (int i = 0; i < numberOfSamples; ++i) {
            Hashtable sample = this.getPriorSample(r);
            if (!this.consistent(sample, evidence)) continue;
            boolean queryValue = (Boolean)sample.get(X);
            if (queryValue) {
                retval[0] = retval[0] + 1.0;
                continue;
            }
            retval[1] = retval[1] + 1.0;
        }
        return Util.normalize(retval);
    }

    private boolean consistent(Hashtable sample, Hashtable evidence) {
        for (String key : evidence.keySet()) {
            Boolean value = (Boolean)evidence.get(key);
            if (value.equals(sample.get(key))) continue;
            return false;
        }
        return true;
    }

    public double[] likelihoodWeighting(String X, Hashtable<String, Boolean> evidence, int numberOfSamples, Randomizer r) {
        double[] retval = new double[2];
        for (int i = 0; i < numberOfSamples; ++i) {
            Hashtable<String, Boolean> x = new Hashtable<String, Boolean>();
            double w = 1.0;
            List<BayesNetNode> variableNodes = this.getVariableNodes();
            for (BayesNetNode node : variableNodes) {
                if (evidence.get(node.getVariable()) != null) {
                    w *= node.probabilityOf(x);
                    x.put(node.getVariable(), evidence.get(node.getVariable()));
                    continue;
                }
                x.put(node.getVariable(), node.isTrueFor(r.nextDouble(), x));
            }
            boolean queryValue = (Boolean)x.get(X);
            if (queryValue) {
                retval[0] = retval[0] + w;
                continue;
            }
            retval[1] = retval[1] + w;
        }
        return Util.normalize(retval);
    }

    public double[] mcmcAsk(String X, Hashtable<String, Boolean> evidence, int numberOfVariables, Randomizer r) {
        double[] retval = new double[2];
        List nonEvidenceVariables = this.nonEvidenceVariables(evidence, X);
        Hashtable<String, Boolean> event = this.createRandomEvent(nonEvidenceVariables, evidence, r);
        for (int j = 0; j < numberOfVariables; ++j) {
            for (String variable : nonEvidenceVariables) {
                BayesNetNode node = this.getNodeOf(variable);
                List<BayesNetNode> markovBlanket = this.markovBlanket(node);
                Hashtable mb = this.createMBValues(markovBlanket, event);
                event.put(node.getVariable(), this.truthValue(this.rejectionSample(node.getVariable(), mb, 100, r), r));
                boolean queryValue = event.get(X);
                if (queryValue) {
                    retval[0] = retval[0] + 1.0;
                    continue;
                }
                retval[1] = retval[1] + 1.0;
            }
        }
        return Util.normalize(retval);
    }

    private Boolean truthValue(double[] ds, Randomizer r) {
        double value = r.nextDouble();
        if (value < ds[0]) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Hashtable<String, Boolean> createRandomEvent(List nonEvidenceVariables, Hashtable<String, Boolean> evidence, Randomizer r) {
        Hashtable<String, Boolean> table = new Hashtable<String, Boolean>();
        List<String> variables = this.getVariables();
        for (String variable : variables) {
            if (nonEvidenceVariables.contains(variable)) {
                Boolean value = r.nextDouble() <= 0.5 ? Boolean.TRUE : Boolean.FALSE;
                table.put(variable, value);
                continue;
            }
            table.put(variable, evidence.get(variable));
        }
        return table;
    }

    private List nonEvidenceVariables(Hashtable<String, Boolean> evidence, String query) {
        ArrayList<String> nonEvidenceVariables = new ArrayList<String>();
        List<String> variables = this.getVariables();
        for (String variable : variables) {
            if (evidence.keySet().contains(variable)) continue;
            nonEvidenceVariables.add(variable);
        }
        return nonEvidenceVariables;
    }

    private List<BayesNetNode> markovBlanket(BayesNetNode node) {
        return this.markovBlanket(node, new ArrayList<BayesNetNode>());
    }

    private List<BayesNetNode> markovBlanket(BayesNetNode node, List<BayesNetNode> soFar) {
        List<BayesNetNode> parents = node.getParents();
        for (BayesNetNode parent : parents) {
            if (soFar.contains(parent)) continue;
            soFar.add(parent);
        }
        List<BayesNetNode> children = node.getChildren();
        for (BayesNetNode child : children) {
            if (soFar.contains(child)) continue;
            soFar.add(child);
            List<BayesNetNode> childsParents = child.getParents();
            for (BayesNetNode childsParent : childsParents) {
                if (soFar.contains(childsParent) || childsParent.equals(node)) continue;
                soFar.add(childsParent);
            }
        }
        return soFar;
    }

    private Hashtable createMBValues(List<BayesNetNode> markovBlanket, Hashtable<String, Boolean> event) {
        Hashtable<String, Boolean> table = new Hashtable<String, Boolean>();
        for (BayesNetNode node : markovBlanket) {
            table.put(node.getVariable(), event.get(node.getVariable()));
        }
        return table;
    }

    public double[] mcmcAsk(String X, Hashtable<String, Boolean> evidence, int numberOfVariables) {
        return this.mcmcAsk(X, evidence, numberOfVariables, new JavaRandomizer());
    }

    public double[] likelihoodWeighting(String X, Hashtable<String, Boolean> evidence, int numberOfSamples) {
        return this.likelihoodWeighting(X, evidence, numberOfSamples, new JavaRandomizer());
    }

    public double[] rejectionSample(String X, Hashtable<String, Boolean> evidence, int numberOfSamples) {
        return this.rejectionSample(X, evidence, numberOfSamples, new JavaRandomizer());
    }
}

