/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.visitors;

import aima.logic.propositional.parsing.AbstractPLVisitor;
import aima.logic.propositional.parsing.ast.BinarySentence;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.UnarySentence;

public class CNFTransformer
extends AbstractPLVisitor {
    @Override
    public Object visitBinarySentence(BinarySentence bs, Object arg) {
        if (bs.isBiconditional()) {
            return this.transformBiConditionalSentence(bs);
        }
        if (bs.isImplication()) {
            return this.transformImpliedSentence(bs);
        }
        if (bs.isOrSentence() && (bs.firstTermIsAndSentence() || bs.secondTermIsAndSentence())) {
            return this.distributeOrOverAnd(bs);
        }
        return super.visitBinarySentence(bs, arg);
    }

    @Override
    public Object visitNotSentence(UnarySentence us, Object arg) {
        return this.transformNotSentence(us);
    }

    public Sentence transform(Sentence s) {
        Sentence toTransform = s;
        while (!toTransform.equals(this.step(toTransform))) {
            toTransform = this.step(toTransform);
        }
        return toTransform;
    }

    private Sentence step(Sentence s) {
        return (Sentence)s.accept(this, null);
    }

    private Sentence transformBiConditionalSentence(BinarySentence bs) {
        BinarySentence first = new BinarySentence("=>", (Sentence)bs.getFirst().accept(this, null), (Sentence)bs.getSecond().accept(this, null));
        BinarySentence second = new BinarySentence("=>", (Sentence)bs.getSecond().accept(this, null), (Sentence)bs.getFirst().accept(this, null));
        return new BinarySentence("AND", first, second);
    }

    private Sentence transformImpliedSentence(BinarySentence bs) {
        UnarySentence first = new UnarySentence((Sentence)bs.getFirst().accept(this, null));
        return new BinarySentence("OR", first, (Sentence)bs.getSecond().accept(this, null));
    }

    private Sentence transformNotSentence(UnarySentence us) {
        if (us.getNegated() instanceof UnarySentence) {
            return (Sentence)((UnarySentence)us.getNegated()).getNegated().accept(this, null);
        }
        if (us.getNegated() instanceof BinarySentence) {
            BinarySentence bs = (BinarySentence)us.getNegated();
            if (bs.isAndSentence()) {
                UnarySentence first = new UnarySentence((Sentence)bs.getFirst().accept(this, null));
                UnarySentence second = new UnarySentence((Sentence)bs.getSecond().accept(this, null));
                return new BinarySentence("OR", first, second);
            }
            if (bs.isOrSentence()) {
                UnarySentence first = new UnarySentence((Sentence)bs.getFirst().accept(this, null));
                UnarySentence second = new UnarySentence((Sentence)bs.getSecond().accept(this, null));
                return new BinarySentence("AND", first, second);
            }
            return (Sentence)super.visitNotSentence(us, null);
        }
        return (Sentence)super.visitNotSentence(us, null);
    }

    private Sentence distributeOrOverAnd(BinarySentence bs) {
        BinarySentence andTerm = bs.firstTermIsAndSentence() ? (BinarySentence)bs.getFirst() : (BinarySentence)bs.getSecond();
        Sentence otherterm = bs.firstTermIsAndSentence() ? bs.getSecond() : bs.getFirst();
        Sentence alpha = (Sentence)otherterm.accept(this, null);
        Sentence beta = (Sentence)andTerm.getFirst().accept(this, null);
        Sentence gamma = (Sentence)andTerm.getSecond().accept(this, null);
        BinarySentence distributed = new BinarySentence("AND", new BinarySentence("OR", alpha, beta), new BinarySentence("OR", alpha, gamma));
        return distributed;
    }
}

