/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.algorithms;

import aima.logic.propositional.algorithms.KnowledgeBase;
import aima.logic.propositional.algorithms.Model;
import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.visitors.SymbolCollector;
import aima.util.Converter;
import aima.util.SetOps;
import aima.util.Util;
import java.util.List;
import java.util.Set;

public class TTEntails {
    public boolean ttEntails(KnowledgeBase kb, String alpha) {
        Sentence kbSentence = kb.asSentence();
        Sentence querySentence = (Sentence)new PEParser().parse(alpha);
        SymbolCollector collector = new SymbolCollector();
        Set<Symbol> kbSymbols = collector.getSymbolsIn(kbSentence);
        Set<Symbol> querySymbols = collector.getSymbolsIn(querySentence);
        Set<Symbol> symbols = new SetOps<Symbol>().union(kbSymbols, querySymbols);
        List<Symbol> symbolList = new Converter<Symbol>().setToList(symbols);
        return this.ttCheckAll(kbSentence, querySentence, symbolList, new Model());
    }

    public boolean ttCheckAll(Sentence kbSentence, Sentence querySentence, List symbols, Model model) {
        if (symbols.isEmpty()) {
            if (model.isTrue(kbSentence)) {
                return model.isTrue(querySentence);
            }
            return true;
        }
        Symbol symbol = (Symbol)Util.first(symbols);
        List rest = Util.rest(symbols);
        Model trueModel = model.extend(new Symbol(symbol.getValue()), true);
        Model falseModel = model.extend(new Symbol(symbol.getValue()), false);
        return this.ttCheckAll(kbSentence, querySentence, rest, trueModel) && this.ttCheckAll(kbSentence, querySentence, rest, falseModel);
    }
}

