/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.propositional.algorithms;

import aima.logic.propositional.algorithms.DPLL;
import aima.logic.propositional.algorithms.TTEntails;
import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.visitors.CNFTransformer;
import aima.util.LogicUtils;
import java.util.ArrayList;
import java.util.List;

public class KnowledgeBase {
    private List<Sentence> sentences = new ArrayList<Sentence>();
    private PEParser parser = new PEParser();

    public void tell(String aSentence) {
        Sentence sentence = (Sentence)this.parser.parse(aSentence);
        if (!this.sentences.contains(sentence)) {
            this.sentences.add(sentence);
        }
    }

    public void tellAll(String[] percepts) {
        for (int i = 0; i < percepts.length; ++i) {
            this.tell(percepts[i]);
        }
    }

    public int size() {
        return this.sentences.size();
    }

    public Sentence asSentence() {
        return LogicUtils.chainWith("AND", this.sentences);
    }

    public boolean askWithDpll(String queryString) {
        Sentence query = null;
        Sentence cnfForm = null;
        try {
            query = (Sentence)this.parser.parse(queryString);
        }
        catch (Exception e) {
            System.out.println("error parsing query" + e.getMessage());
        }
        Sentence kbSentence = this.asSentence();
        Sentence kbPlusQuery = null;
        kbPlusQuery = kbSentence != null ? (Sentence)this.parser.parse(" ( " + kbSentence.toString() + " AND " + queryString + " )") : query;
        try {
            cnfForm = new CNFTransformer().transform(kbPlusQuery);
        }
        catch (Exception e) {
            System.out.println("error converting kb +  query to CNF" + e.getMessage());
        }
        return new DPLL().dpllSatisfiable(cnfForm);
    }

    public boolean askWithTTEntails(String queryString) {
        return new TTEntails().ttEntails(this, queryString);
    }

    public String toString() {
        if (this.sentences.size() == 0) {
            return "";
        }
        return this.asSentence().toString();
    }

    public List getSentences() {
        return this.sentences;
    }
}

