/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference;

import aima.logic.fol.inference.InferenceProcedure;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.inference.proof.Proof;
import aima.logic.fol.inference.proof.ProofFinal;
import aima.logic.fol.inference.proof.ProofStep;
import aima.logic.fol.inference.proof.ProofStepFoChAlreadyAFact;
import aima.logic.fol.inference.proof.ProofStepFoChAssertFact;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FOLFCAsk
implements InferenceProcedure {
    @Override
    public InferenceResult ask(FOLKnowledgeBase KB, Sentence query) {
        if (!(query instanceof AtomicSentence)) {
            throw new IllegalArgumentException("Only Atomic Queries are supported.");
        }
        FCAskAnswerHandler ansHandler = new FCAskAnswerHandler();
        Literal alpha = new Literal((AtomicSentence)query);
        ArrayList<Literal> newSentences = new ArrayList<Literal>();
        Set<Map<Variable, Term>> answers = KB.fetch(alpha);
        if (answers.size() > 0) {
            ansHandler.addProofStep(new ProofStepFoChAlreadyAFact(alpha));
            ansHandler.setAnswers(answers);
            return ansHandler;
        }
        do {
            newSentences.clear();
            for (Clause impl : KB.getAllDefiniteClauseImplications()) {
                impl = KB.standardizeApart(impl);
                for (Map<Variable, Term> theta : KB.fetch(this.invert(impl.getNegativeLiterals()))) {
                    Literal qDelta = KB.subst(theta, impl.getPositiveLiterals().get(0));
                    if (KB.isRenaming(qDelta) || KB.isRenaming(qDelta, newSentences)) continue;
                    newSentences.add(qDelta);
                    ansHandler.addProofStep(impl, qDelta, theta);
                    theta = KB.unify(qDelta.getAtomicSentence(), alpha.getAtomicSentence());
                    if (null == theta) continue;
                    for (Literal l : newSentences) {
                        Sentence s = null;
                        s = l.isPositiveLiteral() ? l.getAtomicSentence() : new NotSentence(l.getAtomicSentence());
                        KB.tell(s);
                    }
                    ansHandler.setAnswers(KB.fetch(alpha));
                    return ansHandler;
                }
            }
            for (Literal l : newSentences) {
                Sentence s = null;
                s = l.isPositiveLiteral() ? l.getAtomicSentence() : new NotSentence(l.getAtomicSentence());
                KB.tell(s);
            }
        } while (newSentences.size() > 0);
        return ansHandler;
    }

    private List<Literal> invert(List<Literal> lits) {
        ArrayList<Literal> invLits = new ArrayList<Literal>();
        for (Literal l : lits) {
            invLits.add(new Literal(l.getAtomicSentence(), l.isPositiveLiteral()));
        }
        return invLits;
    }

    class FCAskAnswerHandler
    implements InferenceResult {
        private ProofStep stepFinal = null;
        private List<Proof> proofs = new ArrayList<Proof>();

        @Override
        public boolean isPossiblyFalse() {
            return this.proofs.size() == 0;
        }

        @Override
        public boolean isTrue() {
            return this.proofs.size() > 0;
        }

        @Override
        public boolean isUnknownDueToTimeout() {
            return false;
        }

        @Override
        public boolean isPartialResultDueToTimeout() {
            return false;
        }

        @Override
        public List<Proof> getProofs() {
            return this.proofs;
        }

        public void addProofStep(Clause implication, Literal fact, Map<Variable, Term> bindings) {
            this.stepFinal = new ProofStepFoChAssertFact(implication, fact, bindings, this.stepFinal);
        }

        public void addProofStep(ProofStep step) {
            this.stepFinal = step;
        }

        public void setAnswers(Set<Map<Variable, Term>> answers) {
            for (Map<Variable, Term> ans : answers) {
                this.proofs.add(new ProofFinal(this.stepFinal, ans));
            }
        }
    }
}

