/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.framework;

import aima.learning.framework.Attribute;
import aima.learning.framework.AttributeSpecification;
import aima.learning.framework.NumericAttribute;

public class NumericAttributeSpecification
implements AttributeSpecification {
    private String name;

    public NumericAttributeSpecification(String name) {
        this.name = name;
    }

    @Override
    public boolean isValid(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getAttributeName() {
        return this.name;
    }

    @Override
    public Attribute createAttribute(String rawValue) {
        return new NumericAttribute(Double.parseDouble(rawValue), this);
    }
}

