/*
 * Decompiled with CFR 0.152.
 */
package mcgraphresolver.controllers;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXSnackbar;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.JFXToggleButton;
import fxgraph.FXEdge;
import fxgraph.FXGraph;
import fxgraph.FXGraphModel;
import fxgraph.FXNode;
import fxgraph.FXNodeGeneric;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import mcgraphresolver.utils.Utils;

public class LinkNodesController
implements Initializable {
    @FXML
    public JFXListView listDestinations;
    public JFXComboBox comboBoxSource;
    public JFXButton btnAdd;
    public JFXButton btnCancel;
    public VBox vbLinkNodes;
    public AnchorPane anchorLinkNodes;
    public BorderPane apLinkNodes;
    private List<FXNodeGeneric> nodeList;
    private List<FXEdge> edgeList;
    private Label sourceNode;
    private FXGraph fxGraph;
    public Utils utils = new Utils();
    private FXNodeGeneric selectedFXNodeGeneric;
    private boolean orientedGraph = true;
    private ResourceBundle resourceBundle;
    private final ObjectProperty<Stage> stage = new SimpleObjectProperty();
    private final ObjectProperty<Scene> scene = new SimpleObjectProperty();
    private JFXSnackbar snackbar;

    public Scene getScene() {
        return (Scene)this.scene.get();
    }

    public void setScene(Scene value) {
        this.scene.set((Object)value);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.resourceBundle = resources;
        this.snackbar = new JFXSnackbar((Pane)this.vbLinkNodes);
    }

    public List<FXEdge> getResults() {
        return this.edgeList;
    }

    public void setGraph(FXGraph graph) {
        this.fxGraph = graph;
    }

    public void setOrientedGraph(boolean orientedGraph) {
        this.orientedGraph = orientedGraph;
    }

    public FXNodeGeneric getFxNodeGenericSource() {
        return this.selectedFXNodeGeneric;
    }

    public void populateItems(String nodeLabel) {
        int positionInComboBoxOfTheCurrentNode = 0;
        int i = 0;
        this.btnAdd.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[0]), () -> this.btnAdd.fire());
        Collection<FXNode> nodes = this.fxGraph.getModel().getNodes();
        this.nodeList = new ArrayList<FXNodeGeneric>();
        for (FXNode node : nodes) {
            this.nodeList.add((FXNodeGeneric)node);
        }
        Collections.sort(this.nodeList);
        for (FXNodeGeneric nodeGeneric : this.nodeList) {
            Label label = new Label(nodeGeneric.getBtnNode().getText());
            label.setStyle("-fx-font-family: 'Roboto Medium'");
            this.comboBoxSource.getItems().add((Object)label);
            if (label.getText().equalsIgnoreCase(nodeLabel)) {
                positionInComboBoxOfTheCurrentNode = i;
            }
            ++i;
        }
        this.comboBoxSource.setPromptText(this.resourceBundle.getString("text_select_source"));
        Collection<FXNode> finalNodes = nodes = new ArrayList<FXNodeGeneric>(this.nodeList);
        this.comboBoxSource.valueProperty().addListener((observable, oldValue, selectedValue) -> {
            this.sourceNode = selectedValue;
            this.listDestinations.getItems().clear();
            this.selectedFXNodeGeneric = (FXNodeGeneric)this.fxGraph.getModel().getNodeGeneric(selectedValue.getText());
            Set<FXEdge> fxEdgeSet = this.fxGraph.getModel().getEdgesFromNode(this.selectedFXNodeGeneric);
            for (FXNode node : finalNodes) {
                if (((FXNodeGeneric)node).getBtnNode().getText().equalsIgnoreCase(selectedValue.getText())) continue;
                Insets insets = new Insets(0.0, 15.0, 0.0, 15.0);
                BorderPane borderPane = new BorderPane();
                Label lbl = new Label(((FXNodeGeneric)node).getBtnNode().getText());
                JFXTextField textField = new JFXTextField();
                textField.setPromptText(this.resourceBundle.getString("text_weight"));
                JFXToggleButton toggleButton = new JFXToggleButton();
                textField.textProperty().addListener((observableTxt, oldValueTxt, newValueTxt) -> {
                    if (!newValueTxt.matches("\\d{0,6}([\\.]\\d{0,2})?")) {
                        textField.setText((String)oldValueTxt);
                    } else if (!textField.getText().isEmpty()) {
                        toggleButton.setSelected(true);
                    } else {
                        toggleButton.setSelected(false);
                    }
                });
                textField.setOnKeyReleased(event -> {
                    if (event.getCode() == KeyCode.ENTER) {
                        this.btnAdd.fire();
                    }
                });
                toggleButton.selectedProperty().addListener((observable1, oldValue1, isSelected) -> {
                    if (isSelected.booleanValue() && textField.getText().isEmpty()) {
                        textField.setText(String.valueOf(1.0));
                    } else if (!isSelected.booleanValue()) {
                        textField.setText("");
                    }
                });
                toggleButton.setSize(7.0);
                if (this.isEdgeContainsNode((FXNodeGeneric)node, fxEdgeSet)) {
                    toggleButton.setSelected(true);
                    textField.setText(String.valueOf(this.getFXEdge((FXNodeGeneric)node, fxEdgeSet).getWeight()));
                }
                lbl.setPrefWidth(200.0);
                lbl.setStyle("-fx-font-family: 'Roboto Medium'");
                textField.setStyle("-fx-font-family: 'Roboto Medium'; -fx-alignment: center");
                borderPane.setLeft((Node)lbl);
                borderPane.setCenter((Node)textField);
                borderPane.setRight((Node)toggleButton);
                BorderPane.setAlignment((Node)lbl, (Pos)Pos.CENTER);
                BorderPane.setAlignment((Node)textField, (Pos)Pos.CENTER);
                BorderPane.setAlignment((Node)toggleButton, (Pos)Pos.CENTER);
                BorderPane.setMargin((Node)textField, (Insets)insets);
                borderPane.setMaxWidth(350.0);
                this.listDestinations.getItems().add((Object)borderPane);
            }
        });
        if (nodeLabel == null) {
            this.comboBoxSource.getSelectionModel().selectFirst();
        } else {
            this.comboBoxSource.getSelectionModel().select(positionInComboBoxOfTheCurrentNode);
        }
    }

    public FXEdge getFXEdge(FXNodeGeneric fxNodeGeneric, Set<FXEdge> fxEdgeSet) {
        for (FXEdge fxEdge : fxEdgeSet) {
            FXNodeGeneric fxNodeGenericSource = (FXNodeGeneric)fxEdge.getSource();
            FXNodeGeneric fxNodeGenericDestination = (FXNodeGeneric)fxEdge.getDestination();
            if (!fxNodeGenericDestination.getBtnNode().getText().equalsIgnoreCase(fxNodeGeneric.getBtnNode().getText())) continue;
            return fxEdge;
        }
        return null;
    }

    public boolean isEdgeContainsNode(FXNodeGeneric fxNodeGeneric, Set<FXEdge> fxEdgeSet) {
        for (FXEdge fxEdge : fxEdgeSet) {
            FXNodeGeneric fxNodeGenericSource = (FXNodeGeneric)fxEdge.getSource();
            FXNodeGeneric fxNodeGenericDestination = (FXNodeGeneric)fxEdge.getDestination();
            if (!fxNodeGenericDestination.getBtnNode().getText().equalsIgnoreCase(fxNodeGeneric.getBtnNode().getText())) continue;
            return true;
        }
        return false;
    }

    @FXML
    private void handleSaveAction(ActionEvent event) {
        ObservableList itemsDestination = this.listDestinations.getItems();
        this.edgeList = new ArrayList<FXEdge>();
        for (Object object : itemsDestination) {
            if (!(object instanceof BorderPane)) continue;
            BorderPane borderPane = (BorderPane)object;
            Label label = (Label)borderPane.getLeft();
            JFXTextField textField = (JFXTextField)borderPane.getCenter();
            JFXToggleButton toggleButton = (JFXToggleButton)borderPane.getRight();
            if (!toggleButton.isSelected()) continue;
            FXGraphModel fxGraphModelGeneric = this.fxGraph.getModel();
            FXEdge fxEdge = new FXEdge(this.fxGraph, fxGraphModelGeneric.getNodeGeneric(this.sourceNode.getText()), fxGraphModelGeneric.getNodeGeneric(label.getText()));
            fxEdge.setWeight(Double.parseDouble(textField.getText()));
            fxEdge.computeDisplayShape(this.fxGraph.getZoomHandler().getCurrentZoomLevel());
            FXEdge otherSideEdge = new FXEdge(this.fxGraph, fxGraphModelGeneric.getNodeGeneric(label.getText()), fxGraphModelGeneric.getNodeGeneric(this.sourceNode.getText()));
            otherSideEdge.setWeight(Double.parseDouble(textField.getText()));
            otherSideEdge.computeDisplayShape(this.fxGraph.getZoomHandler().getCurrentZoomLevel());
            fxEdge.setOriented(this.orientedGraph);
            otherSideEdge.setOriented(this.orientedGraph);
            this.edgeList.add(fxEdge);
            if (this.orientedGraph) continue;
            this.edgeList.add(otherSideEdge);
        }
        Node source = (Node)event.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void handleExitAction(ActionEvent event) {
        Node source = (Node)event.getSource();
        Stage stage = (Stage)source.getScene().getWindow();
        stage.close();
    }
}

