/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.utils;

import com.jfoenix.concurrency.JFXUtilities;
import com.jfoenix.utils.JFXHighlighter$$Lambda$1;
import com.jfoenix.utils.JFXHighlighter$$Lambda$2;
import com.jfoenix.utils.JFXHighlighter$$Lambda$3;
import com.jfoenix.utils.JFXHighlighter$$Lambda$4;
import com.jfoenix.utils.JFXHighlighter$HighLightRectangle$$Lambda$1;
import com.jfoenix.utils.JFXHighlighter$HighLightRectangle$$Lambda$2;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLine;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.effect.BlendMode;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;

public class JFXHighlighter {
    private Pane pane;
    private HashMap<Node, List<Rectangle>> boxes = new HashMap();
    private ObjectProperty<Paint> paint = new SimpleObjectProperty((Object)Color.rgb((int)255, (int)0, (int)0, (double)0.4));
    private Method textLayoutMethod;

    public JFXHighlighter() {
        try {
            this.textLayoutMethod = Text.class.getDeclaredMethod("getTextLayout", new Class[0]);
            this.textLayoutMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public synchronized void highlight(Pane pane, String query) {
        if (this.pane != null && !this.boxes.isEmpty()) {
            this.clear();
        }
        if (query.isEmpty()) {
            return;
        }
        this.pane = pane;
        Set<Node> nodes = this.getTextNodes(pane);
        ArrayList allRectangles = new ArrayList();
        nodes.forEach(JFXHighlighter$$Lambda$1.lambdaFactory$(this, query, allRectangles));
        Platform.runLater((Runnable)JFXHighlighter$$Lambda$2.lambdaFactory$(pane, allRectangles));
    }

    private Set<Node> getTextNodes(Pane pane) {
        Set labeledTextNodes = pane.lookupAll("LabeledText");
        Set textNodes = pane.lookupAll("Text");
        HashSet<Node> nodes = new HashSet<Node>();
        nodes.addAll(labeledTextNodes);
        nodes.addAll(textNodes);
        return nodes;
    }

    private ArrayList<Bounds> getMatchingBounds(String query, Node node, Text text) {
        Bounds sceneBounds = node.localToScene(text.getLayoutBounds());
        Bounds parentSceneBounds = this.pane.localToScene(this.pane.getLayoutBounds());
        ArrayList<Bounds> rectBounds = new ArrayList<Bounds>();
        TextLayout textLayout = null;
        try {
            textLayout = (TextLayout)this.textLayoutMethod.invoke((Object)text, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        int queryLength = query.length();
        TextLine[] lines = textLayout.getLines();
        for (int i = 0; i < lines.length; ++i) {
            String queryLow;
            TextLine line = lines[i];
            String lineText = text.getText().substring(line.getStart(), line.getStart() + line.getLength());
            String lineTextLow = lineText.toLowerCase();
            int beginIndex = lineTextLow.indexOf(queryLow = query.toLowerCase());
            if (beginIndex == -1) continue;
            RectBounds lineBounds = line.getBounds();
            double height = Math.round(lineBounds.getMaxY()) - Math.round(lineBounds.getMinY());
            double startY = height * (double)i;
            while (beginIndex != -1) {
                Text temp = new Text(lineText.substring(beginIndex, beginIndex + queryLength));
                temp.setFont(text.getFont());
                temp.applyCss();
                double width = temp.getLayoutBounds().getWidth();
                temp.setText(lineText.substring(0, beginIndex + queryLength));
                temp.applyCss();
                double maxX = temp.getLayoutBounds().getMaxX();
                double startX = maxX - width;
                rectBounds.add((Bounds)new BoundingBox(sceneBounds.getMinX() + startX - parentSceneBounds.getMinX(), sceneBounds.getMinY() - parentSceneBounds.getMinY() + startY, width, temp.getLayoutBounds().getHeight()));
                beginIndex = lineTextLow.indexOf(queryLow, beginIndex + queryLength);
            }
        }
        return rectBounds;
    }

    public synchronized void clear() {
        ArrayList allBoxes = new ArrayList();
        Collection<List<Rectangle>> collection = this.boxes.values();
        ArrayList arrayList = allBoxes;
        arrayList.getClass();
        collection.forEach(JFXHighlighter$$Lambda$3.lambdaFactory$(arrayList));
        this.boxes.clear();
        if (this.pane != null) {
            JFXUtilities.runInFX(JFXHighlighter$$Lambda$4.lambdaFactory$(this, allBoxes));
        }
    }

    public Paint getPaint() {
        return (Paint)this.paint.get();
    }

    public ObjectProperty<Paint> paintProperty() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint.set((Object)paint);
    }

    static /* synthetic */ void lambda$clear$2(JFXHighlighter this_, List allBoxes) {
        this_.pane.getChildren().removeAll((Collection)allBoxes);
    }

    static /* synthetic */ void lambda$highlight$1(Pane pane, ArrayList allRectangles) {
        pane.getChildren().addAll((Collection)allRectangles);
    }

    static /* synthetic */ void lambda$highlight$0(JFXHighlighter this_, String query, ArrayList allRectangles, Node node) {
        Text text = (Text)node;
        int beginIndex = text.getText().toLowerCase().indexOf(query.toLowerCase());
        if (node.isVisible() && beginIndex > -1) {
            ArrayList<Bounds> boundingBoxes = this_.getMatchingBounds(query, node, text);
            ArrayList<HighLightRectangle> rectangles = new ArrayList<HighLightRectangle>();
            for (Bounds boundingBox : boundingBoxes) {
                HighLightRectangle rect = this_.new HighLightRectangle(text);
                rect.setCacheHint(CacheHint.SPEED);
                rect.setCache(true);
                rect.setMouseTransparent(true);
                rect.setBlendMode(BlendMode.MULTIPLY);
                rect.fillProperty().bind(this_.paintProperty());
                rect.setManaged(false);
                rect.setX(boundingBox.getMinX());
                rect.setY(boundingBox.getMinY());
                rect.setWidth(boundingBox.getWidth());
                rect.setHeight(boundingBox.getHeight());
                rectangles.add(rect);
                allRectangles.add(rect);
            }
            this_.boxes.put(node, rectangles);
        }
    }

    private class HighLightRectangle
    extends Rectangle {
        private InvalidationListener listener;

        public HighLightRectangle(Text text) {
            this.listener = JFXHighlighter$HighLightRectangle$$Lambda$1.lambdaFactory$(this, text);
            text.textProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listener));
            text.localToSceneTransformProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listener));
        }

        private void clear(Text text) {
            if (JFXHighlighter.this.boxes.get(text) != null && !((List)JFXHighlighter.this.boxes.get(text)).isEmpty()) {
                Platform.runLater((Runnable)JFXHighlighter$HighLightRectangle$$Lambda$2.lambdaFactory$(this, text));
            }
        }

        static /* synthetic */ void lambda$clear$1(HighLightRectangle this_, Text text) {
            this_.JFXHighlighter.this.pane.getChildren().removeAll((Collection)this_.JFXHighlighter.this.boxes.get(text));
        }

        static /* synthetic */ void lambda$new$0(HighLightRectangle this_, Text text, Observable observable) {
            this_.clear(text);
        }
    }
}

