/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.JFXTreeTableColumn;
import com.jfoenix.controls.JFXTreeTableView;
import com.jfoenix.controls.behavior.JFXTreeTableCellBehavior;
import com.jfoenix.controls.cells.editors.base.JFXTreeTableCell;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import com.sun.javafx.scene.control.behavior.TreeTableCellBehavior;
import com.sun.javafx.scene.control.skin.TableCellSkinBase;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;

public class JFXTreeTableCellSkin<S, T>
extends TableCellSkinBase<TreeTableCell<S, T>, TreeTableCellBehavior<S, T>> {
    private final TreeTableColumn<S, T> tableColumn;

    public JFXTreeTableCellSkin(TreeTableCell<S, T> treeTableCell) {
        super(treeTableCell, new JFXTreeTableCellBehavior<S, T>(treeTableCell));
        this.tableColumn = treeTableCell.getTableColumn();
        super.init(treeTableCell);
    }

    protected void updateChildren() {
        super.updateChildren();
        this.updateDisclosureNode();
    }

    private void updateDisclosureNode() {
        Node disclosureNode = ((JFXTreeTableCell)this.getSkinnable()).getDisclosureNode();
        if (disclosureNode != null) {
            TreeItem item = ((TreeTableCell)this.getSkinnable()).getTreeTableRow().getTreeItem();
            boolean disclosureVisible = item != null && !item.isLeaf() && item.getValue() != null && ((RecursiveTreeObject)item.getValue()).getGroupedColumn() == this.tableColumn;
            disclosureNode.setVisible(disclosureVisible);
            if (!disclosureVisible) {
                this.getChildren().remove((Object)disclosureNode);
            } else if (disclosureNode.getParent() == null) {
                this.getChildren().add((Object)disclosureNode);
                disclosureNode.toFront();
            } else {
                disclosureNode.toBack();
            }
            if (disclosureNode.getScene() != null) {
                disclosureNode.applyCss();
            }
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        this.updateDisclosureNode();
        Node disclosureNode = ((JFXTreeTableCell)this.getSkinnable()).getDisclosureNode();
        if (disclosureNode.isVisible()) {
            Pos alighnment = ((TreeTableCell)this.getSkinnable()).getAlignment();
            alighnment = alighnment == null ? Pos.CENTER_LEFT : alighnment;
            this.layoutInArea(disclosureNode, x + 8.0, y, w, h, 0.0, Insets.EMPTY, false, false, HPos.LEFT, VPos.CENTER);
        }
        super.layoutChildren(x, y, w, h);
    }

    protected BooleanProperty columnVisibleProperty() {
        return this.tableColumn.visibleProperty();
    }

    protected ReadOnlyDoubleProperty columnWidthProperty() {
        return this.tableColumn.widthProperty();
    }

    protected double leftLabelPadding() {
        double leftPadding = super.leftLabelPadding();
        double height = this.getCellSize();
        TreeTableColumn tableColumn = ((TreeTableCell)this.getSkinnable()).getTableColumn();
        if (tableColumn == null) {
            return leftPadding;
        }
        TreeTableView treeTable = ((TreeTableCell)this.getSkinnable()).getTreeTableView();
        if (treeTable == null) {
            return leftPadding;
        }
        int columnIndex = treeTable.getVisibleLeafIndex(tableColumn);
        TreeTableColumn treeColumn = treeTable.getTreeColumn();
        if (!(treeTable instanceof JFXTreeTableView) && (treeColumn == null && columnIndex != 0 || treeColumn != null && !tableColumn.equals(treeColumn))) {
            return leftPadding;
        }
        TreeTableRow treeTableRow = ((TreeTableCell)this.getSkinnable()).getTreeTableRow();
        if (treeTableRow == null) {
            return leftPadding;
        }
        TreeItem treeItem = ((TreeTableCell)this.getSkinnable()).getTreeTableRow().getTreeItem();
        if (treeItem == null) {
            return leftPadding;
        }
        Node disclosureNode = ((JFXTreeTableCell)this.getSkinnable()).getDisclosureNode();
        if (((JFXTreeTableColumn)tableColumn).isGrouped()) {
            leftPadding += disclosureNode.prefWidth(-1.0) + 18.0;
        }
        return leftPadding += treeItem.getGraphic() == null ? 0.0 : treeItem.getGraphic().prefWidth(height);
    }
}

