/*
 * Decompiled with CFR 0.152.
 */
package aima.test.tvenvironmenttest;

import aima.basic.BasicEnvironmentView;
import aima.basic.vaccum.ReflexVaccumAgent;
import aima.basic.vaccum.TrivialVaccumEnvironment;
import junit.framework.TestCase;

public class ReflexVaccumAgentTest
extends TestCase {
    private ReflexVaccumAgent agent;
    private StringBuffer envChanges;

    @Override
    public void setUp() {
        this.agent = new ReflexVaccumAgent();
        this.envChanges = new StringBuffer();
    }

    public void testCleanClean() {
        TrivialVaccumEnvironment tve = new TrivialVaccumEnvironment("Clean", "Clean");
        tve.addAgent(this.agent, "A");
        tve.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                ReflexVaccumAgentTest.this.envChanges.append(command);
            }
        });
        tve.step(8);
        ReflexVaccumAgentTest.assertEquals("RightLeftRightLeftRightLeftRightLeft", this.envChanges.toString());
    }

    public void testCleanDirty() {
        TrivialVaccumEnvironment tve = new TrivialVaccumEnvironment("Clean", "Dirty");
        tve.addAgent(this.agent, "A");
        tve.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                ReflexVaccumAgentTest.this.envChanges.append(command);
            }
        });
        tve.step(8);
        ReflexVaccumAgentTest.assertEquals("RightSuckLeftRightLeftRightLeftRight", this.envChanges.toString());
    }

    public void testDirtyClean() {
        TrivialVaccumEnvironment tve = new TrivialVaccumEnvironment("Dirty", "Clean");
        tve.addAgent(this.agent, "A");
        tve.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                ReflexVaccumAgentTest.this.envChanges.append(command);
            }
        });
        tve.step(8);
        ReflexVaccumAgentTest.assertEquals("SuckRightLeftRightLeftRightLeftRight", this.envChanges.toString());
    }

    public void testDirtyDirty() {
        TrivialVaccumEnvironment tve = new TrivialVaccumEnvironment("Dirty", "Dirty");
        tve.addAgent(this.agent, "A");
        tve.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                ReflexVaccumAgentTest.this.envChanges.append(command);
            }
        });
        tve.step(8);
        ReflexVaccumAgentTest.assertEquals("SuckRightSuckLeftRightLeftRightLeft", this.envChanges.toString());
    }
}

