/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.searches;

import aima.search.framework.Problem;
import aima.search.framework.SearchAgent;
import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensGoalTest;
import aima.search.nqueens.NQueensSuccessorFunction;
import aima.search.uninformed.DepthLimitedSearch;
import java.util.List;
import junit.framework.TestCase;

public class DepthLimitedSearchTest
extends TestCase {
    public void testSuccesfulDepthLimitedSearch() throws Exception {
        Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
        DepthLimitedSearch search = new DepthLimitedSearch(8);
        SearchAgent agent = new SearchAgent(problem, search);
        List actions2 = agent.getActions();
        this.assertCorrectPlacement(actions2);
        DepthLimitedSearchTest.assertEquals("113", agent.getInstrumentation().getProperty("nodesExpanded"));
    }

    public void testCutOff() throws Exception {
        Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
        DepthLimitedSearch search = new DepthLimitedSearch(1);
        SearchAgent agent = new SearchAgent(problem, search);
        List actions2 = agent.getActions();
        DepthLimitedSearchTest.assertEquals((Object)"cutoff", actions2.get(0));
    }

    public void testFailure() throws Exception {
        Problem problem = new Problem(new NQueensBoard(3), new NQueensSuccessorFunction(), new NQueensGoalTest());
        DepthLimitedSearch search = new DepthLimitedSearch(5);
        SearchAgent agent = new SearchAgent(problem, search);
        List actions2 = agent.getActions();
        DepthLimitedSearchTest.assertEquals(0, actions2.size());
    }

    private void assertCorrectPlacement(List actions2) {
        DepthLimitedSearchTest.assertEquals(8, actions2.size());
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 0  0", actions2.get(0));
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 1  4", actions2.get(1));
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 2  7", actions2.get(2));
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 3  5", actions2.get(3));
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 4  2", actions2.get(4));
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 5  6", actions2.get(5));
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 6  1", actions2.get(6));
        DepthLimitedSearchTest.assertEquals((Object)"placeQueenAt 7  3", actions2.get(7));
    }
}

