/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.searches;

import aima.search.framework.Problem;
import aima.search.framework.SearchAgent;
import aima.search.framework.TreeSearch;
import aima.search.nqueens.NQueensBoard;
import aima.search.nqueens.NQueensGoalTest;
import aima.search.nqueens.NQueensSuccessorFunction;
import aima.search.uninformed.BreadthFirstSearch;
import java.util.List;
import junit.framework.TestCase;

public class BreadthFirstSearchTest
extends TestCase {
    public void testBreadthFirstSuccesfulSearch() throws Exception {
        Problem problem = new Problem(new NQueensBoard(8), new NQueensSuccessorFunction(), new NQueensGoalTest());
        BreadthFirstSearch search = new BreadthFirstSearch(new TreeSearch());
        SearchAgent agent = new SearchAgent(problem, search);
        List actions2 = agent.getActions();
        this.assertCorrectPlacement(actions2);
        BreadthFirstSearchTest.assertEquals("1965", agent.getInstrumentation().getProperty("nodesExpanded"));
        problem = new Problem(new NQueensBoard(3), new NQueensSuccessorFunction(), new NQueensGoalTest());
        agent = new SearchAgent(problem, search);
        actions2 = agent.getActions();
        BreadthFirstSearchTest.assertEquals(0, actions2.size());
        BreadthFirstSearchTest.assertEquals("6", agent.getInstrumentation().getProperty("nodesExpanded"));
    }

    public void testBreadthFirstUnSuccesfulSearch() throws Exception {
        Problem problem = new Problem(new NQueensBoard(3), new NQueensSuccessorFunction(), new NQueensGoalTest());
        BreadthFirstSearch search = new BreadthFirstSearch(new TreeSearch());
        SearchAgent agent = new SearchAgent(problem, search);
        List actions2 = agent.getActions();
        BreadthFirstSearchTest.assertEquals(0, actions2.size());
        BreadthFirstSearchTest.assertEquals("6", agent.getInstrumentation().getProperty("nodesExpanded"));
    }

    private void assertCorrectPlacement(List actions2) {
        BreadthFirstSearchTest.assertEquals(8, actions2.size());
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 0  0", actions2.get(0));
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 1  4", actions2.get(1));
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 2  7", actions2.get(2));
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 3  5", actions2.get(3));
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 4  2", actions2.get(4));
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 5  6", actions2.get(5));
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 6  1", actions2.get(6));
        BreadthFirstSearchTest.assertEquals((Object)"placeQueenAt 7  3", actions2.get(7));
    }
}

