/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search;

import aima.util.AbstractQueue;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class QueueTest
extends TestCase {
    private AbstractQueue queue;

    @Override
    public void setUp() {
        this.queue = new AbstractQueue();
    }

    public void testInitialization() {
        QueueTest.assertEquals(0, this.queue.size());
        QueueTest.assertTrue(this.queue.isEmpty());
    }

    public void testGetFirst() {
        this.queue.addToFront("Hello");
        QueueTest.assertEquals(1, this.queue.size());
        QueueTest.assertFalse(this.queue.isEmpty());
        String s = (String)this.queue.getFirst();
        QueueTest.assertEquals("Hello", s);
        QueueTest.assertFalse(this.queue.isEmpty());
    }

    public void testRemoveFirst() {
        this.queue.addToFront("Hello");
        QueueTest.assertEquals(1, this.queue.size());
        QueueTest.assertFalse(this.queue.isEmpty());
        String s = (String)this.queue.removeFirst();
        QueueTest.assertEquals("Hello", s);
        QueueTest.assertTrue(this.queue.isEmpty());
    }

    public void testGetLast() {
        this.queue.addToFront("Hello");
        QueueTest.assertEquals(1, this.queue.size());
        QueueTest.assertFalse(this.queue.isEmpty());
        String s = (String)this.queue.getLast();
        QueueTest.assertEquals("Hello", s);
        QueueTest.assertFalse(this.queue.isEmpty());
    }

    public void testRemoveLast() {
        this.queue.addToFront("Hello");
        QueueTest.assertEquals(1, this.queue.size());
        QueueTest.assertFalse(this.queue.isEmpty());
        String s = (String)this.queue.removeLast();
        QueueTest.assertEquals("Hello", s);
        QueueTest.assertTrue(this.queue.isEmpty());
    }

    public void testAddToFront() {
        this.queue.addToFront("Hello");
        QueueTest.assertEquals(1, this.queue.size());
        QueueTest.assertFalse(this.queue.isEmpty());
        this.queue.addToFront("Hi");
        QueueTest.assertEquals(2, this.queue.size());
        QueueTest.assertFalse(this.queue.isEmpty());
        String s = (String)this.queue.removeFirst();
        QueueTest.assertEquals("Hi", s);
        QueueTest.assertEquals(1, this.queue.size());
        QueueTest.assertEquals((Object)"Hello", this.queue.getFirst());
    }

    public void testAddToBack() {
        this.queue.addToBack("Hello");
        QueueTest.assertEquals(1, this.queue.size());
        QueueTest.assertFalse(this.queue.isEmpty());
        this.queue.addToBack("Hi");
        QueueTest.assertEquals(2, this.queue.size());
        QueueTest.assertFalse(this.queue.isEmpty());
        String s = (String)this.queue.removeFirst();
        QueueTest.assertEquals("Hello", s);
        QueueTest.assertEquals(1, this.queue.size());
        QueueTest.assertEquals((Object)"Hi", this.queue.getFirst());
    }

    public void testMultipleAddToFront() {
        this.queue.addToFront("Hello");
        QueueTest.assertEquals(1, this.queue.size());
        QueueTest.assertFalse(this.queue.isEmpty());
        ArrayList<String> l = new ArrayList<String>();
        l.add("Hi");
        l.add("Bye");
        this.queue.addToFront(l);
        QueueTest.assertEquals(3, this.queue.size());
        String s = (String)this.queue.removeFirst();
        QueueTest.assertEquals("Hi", s);
        QueueTest.assertEquals(2, this.queue.size());
        QueueTest.assertEquals((Object)"Bye", this.queue.getFirst());
    }

    public void testMultipleAddToBack() {
        this.queue.addToFront("Hello");
        QueueTest.assertEquals(1, this.queue.size());
        QueueTest.assertFalse(this.queue.isEmpty());
        ArrayList<String> l = new ArrayList<String>();
        l.add("Hi");
        l.add("Bye");
        this.queue.addToBack(l);
        QueueTest.assertEquals(3, this.queue.size());
        String s = (String)this.queue.removeFirst();
        QueueTest.assertEquals("Hello", s);
        QueueTest.assertEquals(2, this.queue.size());
        QueueTest.assertEquals((Object)"Hi", this.queue.getFirst());
    }

    public void testAsList() {
        this.queue.addToFront("Hello");
        ArrayList<String> l = new ArrayList<String>();
        l.add("Hi");
        l.add("Bye");
        this.queue.addToBack(l);
        QueueTest.assertEquals(3, this.queue.size());
        List list = this.queue.asList();
        QueueTest.assertEquals(3, list.size());
    }

    public void testExceptions() {
        try {
            this.queue.add("Hello");
            QueueTest.fail("Runtime Exception should have been thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.queue.remove();
            QueueTest.fail("Runtime Exception should have been thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.queue.get();
            QueueTest.fail("Runtime Exception should have been thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ArrayList l = new ArrayList();
        try {
            this.queue.add(l);
            QueueTest.fail("Runtime Exception should have been thrown");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

