/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.visitors;

import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.visitors.SymbolCollector;
import java.util.Set;
import junit.framework.TestCase;

public class SymbolCollectorTest
extends TestCase {
    private PEParser parser;
    private SymbolCollector collector;

    @Override
    public void setUp() {
        this.parser = new PEParser();
        this.collector = new SymbolCollector();
    }

    public void testCollectSymbolsFromComplexSentence() {
        Sentence sentence = (Sentence)this.parser.parse(" (  (  ( NOT B11 )  OR  ( P12 OR P21 ) ) AND  (  ( B11 OR  ( NOT P12 )  ) AND  ( B11 OR  ( NOT P21 )  ) ) )");
        Set<Symbol> s = this.collector.getSymbolsIn(sentence);
        SymbolCollectorTest.assertEquals(3, s.size());
        Sentence b11 = (Sentence)this.parser.parse("B11");
        Sentence p21 = (Sentence)this.parser.parse("P21");
        Sentence p12 = (Sentence)this.parser.parse("P12");
        SymbolCollectorTest.assertTrue(s.contains(b11));
        SymbolCollectorTest.assertTrue(s.contains(p21));
        SymbolCollectorTest.assertTrue(s.contains(p12));
    }
}

