/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.algorithms;

import aima.logic.propositional.algorithms.DPLL;
import aima.logic.propositional.algorithms.KnowledgeBase;
import aima.logic.propositional.algorithms.Model;
import aima.logic.propositional.parsing.PEParser;
import aima.logic.propositional.parsing.ast.Sentence;
import aima.logic.propositional.parsing.ast.Symbol;
import aima.logic.propositional.visitors.CNFClauseGatherer;
import aima.logic.propositional.visitors.CNFTransformer;
import aima.logic.propositional.visitors.SymbolCollector;
import aima.util.Converter;
import java.util.List;
import junit.framework.TestCase;

public class DPLLTest
extends TestCase {
    private KnowledgeBase one;
    private KnowledgeBase two;
    private KnowledgeBase three;
    private KnowledgeBase four;
    private DPLL dpll;
    private PEParser parser;

    @Override
    public void setUp() {
        this.parser = new PEParser();
        this.dpll = new DPLL();
    }

    public void testDPLLReturnsTrueWhenAllClausesTrueInModel() {
        Model model = new Model();
        model = model.extend(new Symbol("A"), true).extend(new Symbol("B"), true);
        Sentence sentence = (Sentence)this.parser.parse("((A AND B) AND (A OR B))");
        boolean satisfiable = this.dpll.dpllSatisfiable(sentence, model);
        DPLLTest.assertEquals(true, satisfiable);
    }

    public void testDPLLReturnsFalseWhenOneClauseFalseInModel() {
        Model model = new Model();
        model = model.extend(new Symbol("A"), true).extend(new Symbol("B"), false);
        Sentence sentence = (Sentence)this.parser.parse("((A OR B) AND (A => B))");
        boolean satisfiable = this.dpll.dpllSatisfiable(sentence, model);
        DPLLTest.assertEquals(false, satisfiable);
    }

    public void testDPLLFiltersClausesTheStatusOfWhichAreKnown() {
        Model model = new Model();
        model = model.extend(new Symbol("A"), true).extend(new Symbol("B"), true);
        Sentence sentence = (Sentence)this.parser.parse("((A AND B) AND (B AND C))");
        List<Sentence> clauseList = new Converter<Sentence>().setToList(new CNFClauseGatherer().getClausesFrom(new CNFTransformer().transform(sentence)));
        List<Sentence> clausesWithNonTrueValues = this.dpll.clausesWithNonTrueValues(clauseList, model);
        DPLLTest.assertEquals(1, clausesWithNonTrueValues.size());
        Sentence nonTrueClause = (Sentence)this.parser.parse("(B AND C)");
        clausesWithNonTrueValues.contains(nonTrueClause);
    }

    public void testDPLLFilteringNonTrueClausesGivesNullWhenAllClausesAreKnown() {
        Model model = new Model();
        model = model.extend(new Symbol("A"), true).extend(new Symbol("B"), true).extend(new Symbol("C"), true);
        Sentence sentence = (Sentence)this.parser.parse("((A AND B) AND (B AND C))");
        List<Sentence> clauseList = new Converter<Sentence>().setToList(new CNFClauseGatherer().getClausesFrom(new CNFTransformer().transform(sentence)));
        List<Sentence> clausesWithNonTrueValues = this.dpll.clausesWithNonTrueValues(clauseList, model);
        DPLLTest.assertEquals(0, clausesWithNonTrueValues.size());
    }

    public void testDPLLFindsPurePositiveSymbolsWhenTheyExist() {
        Model model = new Model();
        model = model.extend(new Symbol("A"), true).extend(new Symbol("B"), true);
        Sentence sentence = (Sentence)this.parser.parse("((A AND B) AND (B AND C))");
        List<Sentence> clauseList = new Converter<Sentence>().setToList(new CNFClauseGatherer().getClausesFrom(new CNFTransformer().transform(sentence)));
        List<Symbol> symbolList = new Converter<Symbol>().setToList(new SymbolCollector().getSymbolsIn(sentence));
        DPLL.SymbolValuePair sv = this.dpll.findPureSymbolValuePair(clauseList, model, symbolList);
        DPLLTest.assertNotNull(sv);
        DPLLTest.assertEquals(new Symbol("C"), sv.symbol);
        DPLLTest.assertEquals(new Boolean(true), sv.value);
    }

    public void testDPLLFindsPureNegativeSymbolsWhenTheyExist() {
        Model model = new Model();
        model = model.extend(new Symbol("A"), true).extend(new Symbol("B"), true);
        Sentence sentence = (Sentence)this.parser.parse("((A AND B) AND ( B  AND (NOT C) ))");
        List<Sentence> clauseList = new Converter<Sentence>().setToList(new CNFClauseGatherer().getClausesFrom(new CNFTransformer().transform(sentence)));
        List<Symbol> symbolList = new Converter<Symbol>().setToList(new SymbolCollector().getSymbolsIn(sentence));
        DPLL.SymbolValuePair sv = this.dpll.findPureSymbolValuePair(clauseList, model, symbolList);
        DPLLTest.assertNotNull(sv);
        DPLLTest.assertEquals(new Symbol("C"), sv.symbol);
        DPLLTest.assertEquals(new Boolean(false), sv.value);
    }

    public void testDPLLSucceedsWithAandNotA() {
        Sentence sentence = (Sentence)this.parser.parse("(A AND (NOT A))");
        boolean satisfiable = this.dpll.dpllSatisfiable(sentence);
        DPLLTest.assertEquals(false, satisfiable);
    }

    public void testDPLLSucceedsWithChadCarffsBugReport() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.tell("(B12 <=> (P11 OR (P13 OR (P22 OR P02))))");
        kb.tell("(B21 <=> (P20 OR (P22 OR (P31 OR P11))))");
        kb.tell("(B01 <=> (P00 OR (P02 OR P11)))");
        kb.tell("(B10 <=> (P11 OR (P20 OR P00)))");
        kb.tell("(NOT B21)");
        kb.tell("(NOT B12)");
        kb.tell("(B10)");
        kb.tell("(B01)");
        DPLLTest.assertTrue(kb.askWithDpll("(P00)"));
        DPLLTest.assertFalse(kb.askWithDpll("(NOT P00)"));
    }

    public void testDPLLSucceedsWithStackOverflowBugReport1() {
        KnowledgeBase kb = new KnowledgeBase();
        Sentence sentence = (Sentence)this.parser.parse("((A OR (NOT A)) AND (A OR B))");
        DPLLTest.assertTrue(this.dpll.dpllSatisfiable(sentence));
    }

    public void testDPLLSucceedsWithChadCarffsBugReport2() {
        KnowledgeBase kb = new KnowledgeBase();
        kb.tell("(B10 <=> (P11 OR (P20 OR P00)))");
        kb.tell("(B01 <=> (P00 OR (P02 OR P11)))");
        kb.tell("(B21 <=> (P20 OR (P22 OR (P31 OR P11))))");
        kb.tell("(B12 <=> (P11 OR (P13 OR (P22 OR P02))))");
        kb.tell("(NOT B21)");
        kb.tell("(NOT B12)");
        kb.tell("(B10)");
        kb.tell("(B01)");
        DPLLTest.assertTrue(kb.askWithDpll("(P00)"));
        DPLLTest.assertFalse(kb.askWithDpll("(NOT P00)"));
    }
}

