/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.Unifier;
import aima.logic.fol.domain.DomainFactory;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.parsing.FOLParser;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import junit.framework.TestCase;

public class UnifierTest
extends TestCase {
    private FOLParser parser;
    private Unifier unifier;
    private Map<Variable, Term> theta;

    @Override
    public void setUp() {
        this.parser = new FOLParser(DomainFactory.knowsDomain());
        this.unifier = new Unifier();
        this.theta = new Hashtable<Variable, Term>();
    }

    public void testFailureIfThetaisNull() {
        Variable var = new Variable("x");
        Sentence sentence = this.parser.parse("Knows(x)");
        this.theta = null;
        Map<Variable, Term> result = this.unifier.unify(var, sentence, this.theta);
        UnifierTest.assertNull(result);
    }

    public void testUnificationFailure() {
        Variable var = new Variable("x");
        Sentence sentence = this.parser.parse("Knows(y)");
        this.theta = null;
        Map<Variable, Term> result = this.unifier.unify(var, sentence, this.theta);
        UnifierTest.assertNull(result);
    }

    public void testThetaPassedBackIfXEqualsYBothVariables() {
        Variable var1 = new Variable("x");
        Variable var2 = new Variable("x");
        this.theta.put(new Variable("dummy"), new Variable("dummy"));
        Map<Variable, Term> result = this.unifier.unify(var1, var2, this.theta);
        UnifierTest.assertEquals(this.theta, result);
        UnifierTest.assertEquals(1, this.theta.keySet().size());
        UnifierTest.assertTrue(this.theta.containsKey(new Variable("dummy")));
    }

    public void testVariableEqualsConstant() {
        Variable var1 = new Variable("x");
        Constant constant = new Constant("John");
        Map<Variable, Term> result = this.unifier.unify(var1, constant, this.theta);
        UnifierTest.assertEquals(this.theta, result);
        UnifierTest.assertEquals(1, this.theta.keySet().size());
        UnifierTest.assertTrue(this.theta.keySet().contains(var1));
        UnifierTest.assertEquals(constant, this.theta.get(var1));
    }

    public void testSimpleVariableUnification() {
        Variable var1 = new Variable("x");
        ArrayList<Term> terms1 = new ArrayList<Term>();
        terms1.add(var1);
        Predicate p1 = new Predicate("King", terms1);
        ArrayList<Term> terms2 = new ArrayList<Term>();
        terms2.add(new Constant("John"));
        Predicate p2 = new Predicate("King", terms2);
        Map<Variable, Term> result = this.unifier.unify(p1, p2, this.theta);
        UnifierTest.assertEquals(this.theta, result);
        UnifierTest.assertEquals(1, this.theta.keySet().size());
        UnifierTest.assertTrue(this.theta.keySet().contains(new Variable("x")));
        UnifierTest.assertEquals(new Constant("John"), this.theta.get(var1));
    }

    public void testKnows1() {
        Sentence query = this.parser.parse("Knows(John,x)");
        Sentence johnKnowsJane = this.parser.parse("Knows(John,Jane)");
        Map<Variable, Term> result = this.unifier.unify(query, johnKnowsJane, this.theta);
        UnifierTest.assertEquals(this.theta, result);
        UnifierTest.assertTrue(this.theta.keySet().contains(new Variable("x")));
        UnifierTest.assertEquals(new Constant("Jane"), this.theta.get(new Variable("x")));
    }

    public void testKnows2() {
        Sentence query = this.parser.parse("Knows(John,x)");
        Sentence johnKnowsJane = this.parser.parse("Knows(y,Bill)");
        Map<Variable, Term> result = this.unifier.unify(query, johnKnowsJane, this.theta);
        UnifierTest.assertEquals(2, result.size());
        UnifierTest.assertEquals(new Constant("Bill"), this.theta.get(new Variable("x")));
        UnifierTest.assertEquals(new Constant("John"), this.theta.get(new Variable("y")));
    }

    public void testKnows3() {
        Sentence query = this.parser.parse("Knows(John,x)");
        Sentence johnKnowsJane = this.parser.parse("Knows(y,Mother(y))");
        Map<Variable, Term> result = this.unifier.unify(query, johnKnowsJane, this.theta);
        UnifierTest.assertEquals(2, result.size());
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Constant("John"));
        Function mother = new Function("Mother", terms);
        UnifierTest.assertEquals(mother, this.theta.get(new Variable("x")));
        UnifierTest.assertEquals(new Constant("John"), this.theta.get(new Variable("y")));
    }

    public void testKnows5() {
        Sentence query = this.parser.parse("Knows(John,x)");
        Sentence johnKnowsJane = this.parser.parse("Knows(y,z)");
        Map<Variable, Term> result = this.unifier.unify(query, johnKnowsJane, this.theta);
        UnifierTest.assertEquals(2, result.size());
        UnifierTest.assertEquals(new Variable("z"), this.theta.get(new Variable("x")));
        UnifierTest.assertEquals(new Constant("John"), this.theta.get(new Variable("y")));
    }

    public void testCascadedOccursCheck() {
        FOLDomain domain = new FOLDomain();
        domain.addPredicate("P");
        domain.addFunction("F");
        domain.addFunction("SF0");
        domain.addFunction("SF1");
        FOLParser parser = new FOLParser(domain);
        Sentence s1 = parser.parse("P(SF1(v2),v2)");
        Sentence s2 = parser.parse("P(v3,SF0(v3))");
        Map<Variable, Term> result = this.unifier.unify(s1, s2);
        UnifierTest.assertNull(result);
        s1 = parser.parse("P(v1,SF0(v1),SF0(v1),SF0(v1),SF0(v1))");
        s2 = parser.parse("P(v2,SF0(v2),v2,     v3,     v2)");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNull(result);
        s1 = parser.parse("P(v1,   F(v2),F(v2),F(v2),v1,      F(F(v1)),F(F(F(v1))),v2)");
        s2 = parser.parse("P(F(v3),v4,   v5,   v6,   F(F(v5)),v4,      F(v3),      F(F(v5)))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNull(result);
    }

    public void testAdditionalVariableMixtures() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addFunction("F");
        domain.addFunction("G");
        domain.addFunction("H");
        domain.addPredicate("P");
        FOLParser parser = new FOLParser(domain);
        Sentence s1 = parser.parse("P(z, x)");
        Sentence s2 = parser.parse("P(x, a)");
        Map<Variable, Term> result = this.unifier.unify(s1, s2);
        UnifierTest.assertEquals("{z=a, x=a}", result.toString());
        s1 = parser.parse("P(x, z)");
        s2 = parser.parse("P(a, x)");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertEquals("{x=a, z=a}", result.toString());
        s1 = parser.parse("P(w, w, w)");
        s2 = parser.parse("P(x, y, z)");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertEquals("{w=z, x=z, y=z}", result.toString());
        s1 = parser.parse("P(x, y, z)");
        s2 = parser.parse("P(w, w, w)");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertEquals("{x=w, y=w, z=w}", result.toString());
        s1 = parser.parse("P(x, B, F(y))");
        s2 = parser.parse("P(A, y, F(z))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertEquals("{x=A, y=B, z=B}", result.toString());
        s1 = parser.parse("P(F(x,B), G(y),         F(z,A))");
        s2 = parser.parse("P(y,      G(F(G(w),w)), F(w,z))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNull(result);
        s1 = parser.parse("P(F(G(A)), x,    F(H(z,z)), H(y,    G(w)))");
        s2 = parser.parse("P(y,       G(z), F(v     ), H(F(w), x   ))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertEquals("{y=F(G(A)), x=G(G(A)), v=H(G(A),G(A)), w=G(A), z=G(A)}", result.toString());
    }

    public void testTermEquality() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addFunction("Plus");
        FOLParser parser = new FOLParser(domain);
        TermEquality te1 = (TermEquality)parser.parse("x = x");
        TermEquality te2 = (TermEquality)parser.parse("x = x");
        Map<Variable, Term> result = this.unifier.unify(te1, te2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(0, result.size());
        te1 = (TermEquality)parser.parse("x1 = x1");
        te2 = (TermEquality)parser.parse("x2 = x2");
        result = this.unifier.unify(te1, te2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(1, result.size());
        UnifierTest.assertEquals("{x1=x2}", result.toString());
        te1 = (TermEquality)parser.parse("x1 = x1");
        te2 = (TermEquality)parser.parse("Plus(A,B) = Plus(A,B)");
        result = this.unifier.unify(te1, te2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(1, result.size());
        UnifierTest.assertEquals("{x1=Plus(A,B)}", result.toString());
        te1 = (TermEquality)parser.parse("x1 = x1");
        te2 = (TermEquality)parser.parse("Plus(A,B) = Plus(A,z1)");
        result = this.unifier.unify(te1, te2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(2, result.size());
        UnifierTest.assertEquals("{x1=Plus(A,B), z1=B}", result.toString());
        te1 = (TermEquality)parser.parse("x1 = x1");
        te2 = (TermEquality)parser.parse("Plus(A,z1) = Plus(A,B)");
        result = this.unifier.unify(te1, te2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(2, result.size());
        UnifierTest.assertEquals("{x1=Plus(A,B), z1=B}", result.toString());
        te1 = (TermEquality)parser.parse("Plus(Plus(Plus(A,B),B, A)) = Plus(Plus(Plus(A,B),B, A))");
        te2 = (TermEquality)parser.parse("Plus(Plus(Plus(A,B),B, A)) = Plus(Plus(Plus(A,B),B, A))");
        result = this.unifier.unify(te1, te2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(0, result.size());
        te1 = (TermEquality)parser.parse("Plus(A,B) = Plus(B,A)");
        te2 = (TermEquality)parser.parse("Plus(A,B) = Plus(A,B)");
        result = this.unifier.unify(te1, te2);
        UnifierTest.assertNull(result);
    }

    public void testNOTSentence() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addConstant("C");
        domain.addFunction("Plus");
        domain.addPredicate("P");
        FOLParser parser = new FOLParser(domain);
        Sentence s1 = parser.parse("NOT(P(A))");
        Sentence s2 = parser.parse("NOT(P(A))");
        Map<Variable, Term> result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(0, result.size());
        s1 = parser.parse("NOT(P(A))");
        s2 = parser.parse("NOT(P(B))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNull(result);
        s1 = parser.parse("NOT(P(A))");
        s2 = parser.parse("NOT(P(x))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(1, result.size());
        UnifierTest.assertEquals(new Constant("A"), result.get(new Variable("x")));
    }

    public void testConnectedSentence() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addConstant("C");
        domain.addFunction("Plus");
        domain.addPredicate("P");
        FOLParser parser = new FOLParser(domain);
        Sentence s1 = parser.parse("(P(A) AND P(B))");
        Sentence s2 = parser.parse("(P(A) AND P(B))");
        Map<Variable, Term> result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(0, result.size());
        s1 = parser.parse("(P(A) AND P(B))");
        s2 = parser.parse("(P(A) AND P(C))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNull(result);
        s1 = parser.parse("(P(A) AND P(B))");
        s2 = parser.parse("(P(A) AND P(x))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(1, result.size());
        UnifierTest.assertEquals(new Constant("B"), result.get(new Variable("x")));
        s1 = parser.parse("(P(A) OR P(B))");
        s2 = parser.parse("(P(A) OR P(B))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(0, result.size());
        s1 = parser.parse("(P(A) OR P(B))");
        s2 = parser.parse("(P(A) OR P(C))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNull(result);
        s1 = parser.parse("(P(A) OR P(B))");
        s2 = parser.parse("(P(A) OR P(x))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(1, result.size());
        UnifierTest.assertEquals(new Constant("B"), result.get(new Variable("x")));
        s1 = parser.parse("(P(A) => P(B))");
        s2 = parser.parse("(P(A) => P(B))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(0, result.size());
        s1 = parser.parse("(P(A) => P(B))");
        s2 = parser.parse("(P(A) => P(C))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNull(result);
        s1 = parser.parse("(P(A) => P(B))");
        s2 = parser.parse("(P(A) => P(x))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(1, result.size());
        UnifierTest.assertEquals(new Constant("B"), result.get(new Variable("x")));
        s1 = parser.parse("(P(A) <=> P(B))");
        s2 = parser.parse("(P(A) <=> P(B))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(0, result.size());
        s1 = parser.parse("(P(A) <=> P(B))");
        s2 = parser.parse("(P(A) <=> P(C))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNull(result);
        s1 = parser.parse("(P(A) <=> P(B))");
        s2 = parser.parse("(P(A) <=> P(x))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(1, result.size());
        UnifierTest.assertEquals(new Constant("B"), result.get(new Variable("x")));
        s1 = parser.parse("((P(A) AND P(B)) OR (P(C) => (P(A) <=> P(C))))");
        s2 = parser.parse("((P(A) AND P(B)) OR (P(C) => (P(A) <=> P(C))))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(0, result.size());
        s1 = parser.parse("((P(A) AND P(B)) OR (P(C) => (P(A) <=> P(C))))");
        s2 = parser.parse("((P(A) AND P(B)) OR (P(C) => (P(A) <=> P(A))))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNull(result);
        s1 = parser.parse("((P(A) AND P(B)) OR (P(C) => (P(A) <=> P(C))))");
        s2 = parser.parse("((P(A) AND P(B)) OR (P(C) => (P(A) <=> P(x))))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(1, result.size());
        UnifierTest.assertEquals(new Constant("C"), result.get(new Variable("x")));
    }

    public void testQuantifiedSentence() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("A");
        domain.addConstant("B");
        domain.addConstant("C");
        domain.addFunction("Plus");
        domain.addPredicate("P");
        FOLParser parser = new FOLParser(domain);
        Sentence s1 = parser.parse("FORALL x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        Sentence s2 = parser.parse("FORALL x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        Map<Variable, Term> result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(0, result.size());
        s1 = parser.parse("FORALL x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        s2 = parser.parse("FORALL x   ((P(x) AND P(A)) OR (P(A) => P(y)))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNull(result);
        s1 = parser.parse("FORALL x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        s2 = parser.parse("FORALL x,y ((P(x) AND P(A)) OR (P(B) => P(y)))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNull(result);
        s1 = parser.parse("FORALL x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        s2 = parser.parse("FORALL x,y ((P(A) AND P(A)) OR (P(A) => P(y)))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(1, result.size());
        UnifierTest.assertEquals(new Constant("A"), result.get(new Variable("x")));
        s1 = parser.parse("EXISTS x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        s2 = parser.parse("EXISTS x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(0, result.size());
        s1 = parser.parse("EXISTS x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        s2 = parser.parse("EXISTS x   ((P(x) AND P(A)) OR (P(A) => P(y)))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNull(result);
        s1 = parser.parse("EXISTS x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        s2 = parser.parse("EXISTS x,y ((P(x) AND P(A)) OR (P(B) => P(y)))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNull(result);
        s1 = parser.parse("EXISTS x,y ((P(x) AND P(A)) OR (P(A) => P(y)))");
        s2 = parser.parse("EXISTS x,y ((P(A) AND P(A)) OR (P(A) => P(y)))");
        result = this.unifier.unify(s1, s2);
        UnifierTest.assertNotNull(result);
        UnifierTest.assertEquals(1, result.size());
        UnifierTest.assertEquals(new Constant("A"), result.get(new Variable("x")));
    }
}

