/*
 * Decompiled with CFR 0.152.
 */
package aima.search.uninformed;

import aima.search.framework.Metrics;
import aima.search.framework.NodeExpander;
import aima.search.framework.Problem;
import aima.search.framework.Search;
import aima.search.uninformed.DepthLimitedSearch;
import java.util.ArrayList;
import java.util.List;

public class IterativeDeepeningSearch
extends NodeExpander
implements Search {
    private static String PATH_COST = "pathCost";
    private final int limit = Integer.MAX_VALUE;
    private final Metrics iterationMetrics = new Metrics();

    public IterativeDeepeningSearch() {
        this.iterationMetrics.set(NODES_EXPANDED, 0);
        this.iterationMetrics.set(PATH_COST, 0);
    }

    @Override
    public List search(Problem p) throws Exception {
        this.iterationMetrics.set(NODES_EXPANDED, 0);
        this.iterationMetrics.set(PATH_COST, 0);
        for (int i = 1; i <= this.limit; ++i) {
            DepthLimitedSearch dls = new DepthLimitedSearch(i);
            List result = dls.search(p);
            this.iterationMetrics.set(NODES_EXPANDED, this.iterationMetrics.getInt(NODES_EXPANDED) + dls.getMetrics().getInt(NODES_EXPANDED));
            if (this.cutOffResult(result)) continue;
            this.iterationMetrics.set(PATH_COST, dls.getPathCost());
            return result;
        }
        return new ArrayList();
    }

    private boolean cutOffResult(List result) {
        return result.size() == 1 && result.get(0).equals("cutoff");
    }

    @Override
    public Metrics getMetrics() {
        return this.iterationMetrics;
    }
}

