/*
 * Decompiled with CFR 0.152.
 */
package aima.search.nqueens;

import aima.basic.XYLocation;
import aima.search.framework.Successor;
import aima.search.framework.SuccessorFunction;
import aima.search.nqueens.NQueensBoard;
import java.util.ArrayList;
import java.util.List;

public class NQueensSuccessorFunction
implements SuccessorFunction {
    @Override
    public List getSuccessors(Object state) {
        ArrayList<Successor> successors = new ArrayList<Successor>();
        NQueensBoard board = (NQueensBoard)state;
        int numQueens = board.getNumberOfQueensOnBoard();
        int boardSize = board.getSize();
        for (int i = 0; i < boardSize; ++i) {
            if (board.isSquareUnderAttack(new XYLocation(numQueens, i))) continue;
            NQueensBoard child = this.placeQueenAt(numQueens, i, board);
            successors.add(new Successor("placeQueenAt " + numQueens + "  " + i, child));
        }
        return successors;
    }

    private NQueensBoard placeQueenAt(int row, int column, NQueensBoard parentBoard) {
        NQueensBoard newBoard = new NQueensBoard(parentBoard.getSize());
        List<XYLocation> queenPositionsOnParentBoard = parentBoard.getQueenPositions();
        queenPositionsOnParentBoard.add(new XYLocation(row, column));
        newBoard.setBoard(queenPositionsOnParentBoard);
        return newBoard;
    }
}

