/*
 * Decompiled with CFR 0.152.
 */
package aima.search.framework;

import aima.search.framework.ExpansionOrder;
import aima.search.framework.Metrics;
import aima.search.framework.Node;
import aima.search.framework.Problem;
import aima.search.framework.Successor;
import java.util.ArrayList;
import java.util.List;
import mcgraphresolver.aima_classes.uninformed.NodeStateUninformed;
import mcgraphresolver.utils.SharePreferencesHandler;

public class NodeExpander {
    private List<Node> arrayListExpandedNode;
    private SharePreferencesHandler sharePreferencesHandler;
    protected Metrics metrics = new Metrics();
    protected static String NODES_EXPANDED = "nodesExpanded";

    public NodeExpander() {
        this.arrayListExpandedNode = new ArrayList<Node>();
        this.sharePreferencesHandler = new SharePreferencesHandler();
    }

    public void clearInstrumentation() {
        this.metrics.set(NODES_EXPANDED, 0);
    }

    private boolean arrayContainsNode(List<Node> arrayList, Node node) {
        if (node.getState() instanceof NodeStateUninformed) {
            String label = ((NodeStateUninformed)node.getState()).getFxNodeGeneric().getBtnNode().getText();
            for (Node node1 : arrayList) {
                if (!(node1.getState() instanceof NodeStateUninformed) || !((NodeStateUninformed)node1.getState()).getFxNodeGeneric().getBtnNode().getText().equals(label)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Node> expandNode(Node node, Problem problem) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (!this.sharePreferencesHandler.isDuplicateNodeCheckingEnabled()) {
            this.expand(nodes, node, problem);
        } else if (!this.arrayContainsNode(this.arrayListExpandedNode, node)) {
            this.arrayListExpandedNode.add(node);
            this.expand(nodes, node, problem);
        }
        return nodes;
    }

    private void expand(List<Node> nodes, Node node, Problem problem) {
        List successors = problem.getSuccessorFunction().getSuccessors(node.getState());
        for (int i = 0; i < successors.size(); ++i) {
            Successor successor = (Successor)successors.get(i);
            Node aNode = new Node(node, successor.getState());
            aNode.setAction(successor.getAction());
            Double stepCost = problem.getStepCostFunction().calculateStepCost(node.getState(), successor.getState(), successor.getAction());
            aNode.setStepCost(stepCost);
            aNode.addToPathCost(stepCost);
            nodes.add(aNode);
        }
        if (node.getState() instanceof ExpansionOrder) {
            ((ExpansionOrder)node.getState()).setExpansionOrder(this.metrics.getInt(NODES_EXPANDED) + 1);
        }
        this.metrics.set(NODES_EXPANDED, this.metrics.getInt(NODES_EXPANDED) + 1);
    }

    public int getNodesExpanded() {
        return this.metrics.getInt(NODES_EXPANDED);
    }

    public void setNodesExpanded(int nodesExpanded) {
        this.metrics.set(NODES_EXPANDED, nodesExpanded);
    }

    public Object getSearchMetric(String name) {
        return this.metrics.get(name);
    }

    public Metrics getMetrics() {
        return this.metrics;
    }
}

