/*
 * Decompiled with CFR 0.152.
 */
package aima.search.eightpuzzle;

import aima.basic.XYLocation;
import java.util.ArrayList;
import java.util.List;

public class EightPuzzleBoard {
    public static String LEFT = "Left";
    public static String RIGHT = "Right";
    public static String UP = "Up";
    public static String DOWN = "Down";
    int[] board;

    public int[] getBoard() {
        return this.board;
    }

    public EightPuzzleBoard() {
        this.board = new int[]{5, 4, 0, 6, 1, 8, 7, 3, 2};
    }

    public EightPuzzleBoard(int[] aBoard) {
        this.board = aBoard;
    }

    private int[] xycoordinatesFromAbsoluteCoordinate(int x) {
        int[] retVal = null;
        switch (x) {
            case 0: {
                retVal = new int[]{0, 0};
                break;
            }
            case 1: {
                retVal = new int[]{0, 1};
                break;
            }
            case 2: {
                retVal = new int[]{0, 2};
                break;
            }
            case 3: {
                retVal = new int[]{1, 0};
                break;
            }
            case 4: {
                retVal = new int[]{1, 1};
                break;
            }
            case 5: {
                retVal = new int[]{1, 2};
                break;
            }
            case 6: {
                retVal = new int[]{2, 0};
                break;
            }
            case 7: {
                retVal = new int[]{2, 1};
                break;
            }
            case 8: {
                retVal = new int[]{2, 2};
            }
        }
        return retVal;
    }

    private int absoluteCoordinatesFromXYCoordinates(int x, int y) {
        return x * 3 + y;
    }

    private int getValueAt(int x, int y) {
        return this.board[this.absoluteCoordinatesFromXYCoordinates(x, y)];
    }

    private int getGapPosition() {
        return this.getPositionOf(0);
    }

    private int getPositionOf(int val) {
        int retVal = -1;
        for (int i = 0; i < 9; ++i) {
            if (this.board[i] != val) continue;
            retVal = i;
        }
        return retVal;
    }

    public XYLocation getLocationOf(int val) {
        int abspos = this.getPositionOf(val);
        int xpos = this.xycoordinatesFromAbsoluteCoordinate(abspos)[0];
        int ypos = this.xycoordinatesFromAbsoluteCoordinate(abspos)[1];
        return new XYLocation(xpos, ypos);
    }

    private void setValue(int xPos, int yPos, int val) {
        int abscoord = this.absoluteCoordinatesFromXYCoordinates(xPos, yPos);
        this.board[abscoord] = val;
    }

    public int getValueAt(XYLocation loc) {
        return this.getValueAt(loc.getXCoOrdinate(), loc.getYCoOrdinate());
    }

    public void moveGapRight() {
        int gapPosition = this.getGapPosition();
        int xpos = this.xycoordinatesFromAbsoluteCoordinate(gapPosition)[0];
        int ypos = this.xycoordinatesFromAbsoluteCoordinate(gapPosition)[1];
        if (ypos != 2) {
            int valueOnRight = this.getValueAt(xpos, ypos + 1);
            this.setValue(xpos, ypos, valueOnRight);
            this.setValue(xpos, ypos + 1, 0);
        }
    }

    public void moveGapLeft() {
        int gapPosition = this.getGapPosition();
        int xpos = this.xycoordinatesFromAbsoluteCoordinate(gapPosition)[0];
        int ypos = this.xycoordinatesFromAbsoluteCoordinate(this.getGapPosition())[1];
        if (ypos != 0) {
            int valueOnLeft = this.getValueAt(xpos, ypos - 1);
            this.setValue(xpos, ypos, valueOnLeft);
            this.setValue(xpos, ypos - 1, 0);
        }
    }

    public void moveGapDown() {
        int gapPosition = this.getGapPosition();
        int xpos = this.xycoordinatesFromAbsoluteCoordinate(gapPosition)[0];
        int ypos = this.xycoordinatesFromAbsoluteCoordinate(gapPosition)[1];
        if (xpos != 2) {
            int valueOnBottom = this.getValueAt(xpos + 1, ypos);
            this.setValue(xpos, ypos, valueOnBottom);
            this.setValue(xpos + 1, ypos, 0);
        }
    }

    public void moveGapUp() {
        int gapPosition = this.getGapPosition();
        int xpos = this.xycoordinatesFromAbsoluteCoordinate(gapPosition)[0];
        int ypos = this.xycoordinatesFromAbsoluteCoordinate(gapPosition)[1];
        if (xpos != 0) {
            int valueOnTop = this.getValueAt(xpos - 1, ypos);
            this.setValue(xpos, ypos, valueOnTop);
            this.setValue(xpos - 1, ypos, 0);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EightPuzzleBoard aBoard = (EightPuzzleBoard)o;
        for (int i = 0; i < 8; ++i) {
            if (this.getPositionOf(i) == aBoard.getPositionOf(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        for (int i = 0; i < 8; ++i) {
            int position = this.getPositionOf(i);
            result = 37 * result + position;
        }
        return result;
    }

    public List<XYLocation> getPositions() {
        ArrayList<XYLocation> retVal = new ArrayList<XYLocation>();
        for (int i = 0; i < 9; ++i) {
            int[] res = this.xycoordinatesFromAbsoluteCoordinate(this.getPositionOf(i));
            XYLocation loc = new XYLocation(res[0], res[1]);
            retVal.add(loc);
        }
        return retVal;
    }

    public void setBoard(List<XYLocation> locs) {
        int count = 0;
        for (int i = 0; i < locs.size(); ++i) {
            XYLocation loc = locs.get(i);
            this.setValue(loc.getXCoOrdinate(), loc.getYCoOrdinate(), count);
            ++count;
        }
    }

    public boolean canMoveGap(String where) {
        boolean retVal = true;
        int absPos = this.getPositionOf(0);
        if (where.equals(LEFT) && (absPos == 0 || absPos == 3 || absPos == 6)) {
            retVal = false;
        }
        if (where.equals(RIGHT) && (absPos == 2 || absPos == 5 || absPos == 8)) {
            retVal = false;
        }
        if (where.equals(UP) && (absPos == 0 || absPos == 1 || absPos == 2)) {
            retVal = false;
        }
        if (where.equals(DOWN) && (absPos == 6 || absPos == 7 || absPos == 8)) {
            retVal = false;
        }
        return retVal;
    }

    public String toString() {
        String retVal = this.board[0] + " " + this.board[1] + " " + this.board[2] + "\n" + this.board[3] + " " + this.board[4] + " " + this.board[5] + " \n" + this.board[6] + " " + this.board[7] + " " + this.board[8];
        return retVal;
    }
}

