/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.kb.data;

import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.Term;

public class Literal {
    private AtomicSentence atom = null;
    private boolean negativeLiteral = false;
    private String strRep = null;
    private int hashCode = 0;

    public Literal(AtomicSentence atom) {
        this.atom = atom;
    }

    public Literal(AtomicSentence atom, boolean negated) {
        this.atom = atom;
        this.negativeLiteral = negated;
    }

    public Literal newInstance(AtomicSentence atom) {
        return new Literal(atom, this.negativeLiteral);
    }

    public boolean isPositiveLiteral() {
        return !this.negativeLiteral;
    }

    public boolean isNegativeLiteral() {
        return this.negativeLiteral;
    }

    public AtomicSentence getAtomicSentence() {
        return this.atom;
    }

    public String toString() {
        if (null == this.strRep) {
            StringBuilder sb = new StringBuilder();
            if (this.isNegativeLiteral()) {
                sb.append("~");
            }
            sb.append(this.getAtomicSentence().toString());
            this.strRep = sb.toString();
        }
        return this.strRep;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!(o instanceof Literal)) {
            return false;
        }
        Literal l = (Literal)o;
        return l.isPositiveLiteral() == this.isPositiveLiteral() && l.getAtomicSentence().getSymbolicName().equals(this.atom.getSymbolicName()) && l.getAtomicSentence().getArgs().equals(this.atom.getArgs());
    }

    public int hashCode() {
        if (0 == this.hashCode) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.getClass().getSimpleName().hashCode() + (this.isPositiveLiteral() ? "+".hashCode() : "-".hashCode()) + this.atom.getSymbolicName().hashCode();
            for (Term t : this.atom.getArgs()) {
                this.hashCode = 37 * this.hashCode + t.hashCode();
            }
        }
        return this.hashCode;
    }
}

