/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference;

import aima.logic.fol.SubstVisitor;
import aima.logic.fol.SubsumptionElimination;
import aima.logic.fol.Unifier;
import aima.logic.fol.inference.IndexedFarParents;
import aima.logic.fol.inference.InferenceProcedure;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.inference.proof.Proof;
import aima.logic.fol.inference.proof.ProofFinal;
import aima.logic.fol.inference.proof.ProofStepChainCancellation;
import aima.logic.fol.inference.proof.ProofStepChainDropped;
import aima.logic.fol.inference.proof.ProofStepChainFromClause;
import aima.logic.fol.inference.proof.ProofStepGoal;
import aima.logic.fol.inference.trace.FOLModelEliminationTracer;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.data.Chain;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.kb.data.ReducedLiteral;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.ConnectedSentence;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FOLModelElimination
implements InferenceProcedure {
    private long maxQueryTime = 10000L;
    private FOLModelEliminationTracer tracer = null;
    private Unifier unifier = new Unifier();
    private SubstVisitor substVisitor = new SubstVisitor();

    public FOLModelElimination() {
    }

    public FOLModelElimination(long maxQueryTime) {
        this.setMaxQueryTime(maxQueryTime);
    }

    public FOLModelElimination(FOLModelEliminationTracer tracer) {
        this.tracer = tracer;
    }

    public FOLModelElimination(FOLModelEliminationTracer tracer, long maxQueryTime) {
        this.tracer = tracer;
        this.setMaxQueryTime(maxQueryTime);
    }

    public long getMaxQueryTime() {
        return this.maxQueryTime;
    }

    public void setMaxQueryTime(long maxQueryTime) {
        this.maxQueryTime = maxQueryTime;
    }

    @Override
    public InferenceResult ask(FOLKnowledgeBase kb, Sentence aQuery) {
        LinkedHashSet<Clause> bgClauses = new LinkedHashSet<Clause>(kb.getAllClauses());
        bgClauses.removeAll(SubsumptionElimination.findSubsumedClauses(bgClauses));
        List<Chain> background = this.createChainsFromClauses(bgClauses);
        AnswerHandler ansHandler = new AnswerHandler(kb, aQuery, this.maxQueryTime);
        IndexedFarParents ifps = new IndexedFarParents(ansHandler.getSetOfSupport(), background);
        for (int maxDepth = 1; maxDepth < Integer.MAX_VALUE; ++maxDepth) {
            ansHandler.resetMaxDepthReached();
            if (null != this.tracer) {
                this.tracer.reset();
            }
            for (Chain nearParent : ansHandler.getSetOfSupport()) {
                this.recursiveDLS(maxDepth, 0, nearParent, ifps, ansHandler);
                if (!ansHandler.isComplete()) continue;
                return ansHandler;
            }
            if (ansHandler.getMaxDepthReached() >= maxDepth) continue;
            return ansHandler;
        }
        return ansHandler;
    }

    private List<Chain> createChainsFromClauses(Set<Clause> clauses) {
        ArrayList<Chain> chains = new ArrayList<Chain>();
        for (Clause c : clauses) {
            Chain chn = new Chain(c.getLiterals());
            chn.setProofStep(new ProofStepChainFromClause(chn, c));
            chains.add(chn);
            chains.addAll(chn.getContrapositives());
        }
        return chains;
    }

    private void recursiveDLS(int maxDepth, int currentDepth, Chain nearParent, IndexedFarParents indexedFarParents, AnswerHandler ansHandler) {
        ansHandler.updateMaxDepthReached(currentDepth);
        if (currentDepth == maxDepth) {
            return;
        }
        int noCandidateFarParents = indexedFarParents.getNumberCandidateFarParents(nearParent);
        if (null != this.tracer) {
            this.tracer.increment(currentDepth, noCandidateFarParents);
        }
        indexedFarParents.standardizeApart(nearParent);
        for (int farParentIdx = 0; farParentIdx < noCandidateFarParents && !ansHandler.isComplete(); ++farParentIdx) {
            Chain nextNearParent = indexedFarParents.attemptReduction(nearParent, farParentIdx);
            if (null == nextNearParent) continue;
            boolean cancelled = false;
            boolean dropped = false;
            do {
                cancelled = false;
                Chain nextParent = null;
                while (nextNearParent != (nextParent = this.tryCancellation(nextNearParent))) {
                    nextNearParent = nextParent;
                    cancelled = true;
                }
                dropped = false;
                while (nextNearParent != (nextParent = this.tryDropping(nextNearParent))) {
                    nextNearParent = nextParent;
                    dropped = true;
                }
            } while (dropped || cancelled);
            if (ansHandler.isAnswer(nextNearParent)) continue;
            int noNextFarParents = indexedFarParents.getNumberFarParents(nextNearParent);
            nextNearParent = indexedFarParents.addToIndex(nextNearParent);
            this.recursiveDLS(maxDepth, currentDepth + 1, nextNearParent, indexedFarParents, ansHandler);
            indexedFarParents.resetNumberFarParentsTo(nextNearParent, noNextFarParents);
        }
    }

    private Chain tryCancellation(Chain c) {
        Literal head = c.getHead();
        if (null != head && !(head instanceof ReducedLiteral)) {
            for (Literal l : c.getTail()) {
                Map<Variable, Term> subst;
                if (!(l instanceof ReducedLiteral) || head.isNegativeLiteral() == l.isNegativeLiteral() || null == (subst = this.unifier.unify(head.getAtomicSentence(), l.getAtomicSentence()))) continue;
                ArrayList<Literal> cancLits = new ArrayList<Literal>();
                for (Literal lfc : c.getTail()) {
                    AtomicSentence a = (AtomicSentence)this.substVisitor.subst(subst, lfc.getAtomicSentence());
                    cancLits.add(lfc.newInstance(a));
                }
                Chain cancellation = new Chain(cancLits);
                cancellation.setProofStep(new ProofStepChainCancellation(cancellation, c, subst));
                return cancellation;
            }
        }
        return c;
    }

    private Chain tryDropping(Chain c) {
        Literal head = c.getHead();
        if (null != head && head instanceof ReducedLiteral) {
            Chain dropped = new Chain(c.getTail());
            dropped.setProofStep(new ProofStepChainDropped(dropped, c));
            return dropped;
        }
        return c;
    }

    class AnswerHandler
    implements InferenceResult {
        private Chain answerChain = new Chain();
        private Set<Variable> answerLiteralVariables;
        private List<Chain> sos = null;
        private boolean complete = false;
        private long finishTime = 0L;
        private int maxDepthReached = 0;
        private List<Proof> proofs = new ArrayList<Proof>();
        private boolean timedOut = false;

        public AnswerHandler(FOLKnowledgeBase kb, Sentence aQuery, long maxQueryTime) {
            this.finishTime = System.currentTimeMillis() + maxQueryTime;
            NotSentence refutationQuery = new NotSentence(aQuery);
            Literal answerLiteral = kb.createAnswerLiteral(refutationQuery);
            this.answerLiteralVariables = kb.collectAllVariables(answerLiteral.getAtomicSentence());
            if (this.answerLiteralVariables.size() > 0) {
                ConnectedSentence refutationQueryWithAnswer = new ConnectedSentence("OR", refutationQuery, answerLiteral.getAtomicSentence().copy());
                this.sos = FOLModelElimination.this.createChainsFromClauses(kb.convertToClauses(refutationQueryWithAnswer));
                this.answerChain.addLiteral(answerLiteral);
            } else {
                this.sos = FOLModelElimination.this.createChainsFromClauses(kb.convertToClauses(refutationQuery));
            }
            for (Chain s : this.sos) {
                s.setProofStep(new ProofStepGoal(s));
            }
        }

        @Override
        public boolean isPossiblyFalse() {
            return !this.timedOut && this.proofs.size() == 0;
        }

        @Override
        public boolean isTrue() {
            return this.proofs.size() > 0;
        }

        @Override
        public boolean isUnknownDueToTimeout() {
            return this.timedOut && this.proofs.size() == 0;
        }

        @Override
        public boolean isPartialResultDueToTimeout() {
            return this.timedOut && this.proofs.size() > 0;
        }

        @Override
        public List<Proof> getProofs() {
            return this.proofs;
        }

        public List<Chain> getSetOfSupport() {
            return this.sos;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public void resetMaxDepthReached() {
            this.maxDepthReached = 0;
        }

        public int getMaxDepthReached() {
            return this.maxDepthReached;
        }

        public void updateMaxDepthReached(int depth) {
            if (depth > this.maxDepthReached) {
                this.maxDepthReached = depth;
            }
        }

        public boolean isAnswer(Chain nearParent) {
            boolean isAns = false;
            if (this.answerChain.isEmpty()) {
                if (nearParent.isEmpty()) {
                    this.proofs.add(new ProofFinal(nearParent.getProofStep(), new HashMap<Variable, Term>()));
                    this.complete = true;
                    isAns = true;
                }
            } else {
                if (nearParent.isEmpty()) {
                    throw new IllegalStateException("Generated an empty chain while looking for an answer, implies original KB is unsatisfiable");
                }
                if (1 == nearParent.getNumberLiterals() && nearParent.getHead().getAtomicSentence().getSymbolicName().equals(this.answerChain.getHead().getAtomicSentence().getSymbolicName())) {
                    HashMap<Variable, Term> answerBindings = new HashMap<Variable, Term>();
                    List<Term> answerTerms = nearParent.getHead().getAtomicSentence().getArgs();
                    int idx = 0;
                    for (Variable v : this.answerLiteralVariables) {
                        answerBindings.put(v, answerTerms.get(idx));
                        ++idx;
                    }
                    boolean addNewAnswer = true;
                    for (Proof p : this.proofs) {
                        if (!p.getAnswerBindings().equals(answerBindings)) continue;
                        addNewAnswer = false;
                        break;
                    }
                    if (addNewAnswer) {
                        this.proofs.add(new ProofFinal(nearParent.getProofStep(), answerBindings));
                    }
                    isAns = true;
                }
            }
            if (System.currentTimeMillis() > this.finishTime) {
                this.complete = true;
                this.timedOut = true;
            }
            return isAns;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("isComplete=" + this.complete);
            sb.append("\n");
            sb.append("result=" + this.proofs);
            return sb.toString();
        }
    }
}

