/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol.inference;

import aima.logic.fol.inference.InferenceProcedure;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.inference.proof.Proof;
import aima.logic.fol.inference.proof.ProofFinal;
import aima.logic.fol.inference.proof.ProofStepBwChGoal;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FOLBCAsk
implements InferenceProcedure {
    @Override
    public InferenceResult ask(FOLKnowledgeBase KB, Sentence query) {
        if (!(query instanceof AtomicSentence)) {
            throw new IllegalArgumentException("Only Atomic Queries are supported.");
        }
        ArrayList<Literal> goals = new ArrayList<Literal>();
        goals.add(new Literal((AtomicSentence)query));
        BCAskAnswerHandler ansHandler = new BCAskAnswerHandler();
        List<List<ProofStepBwChGoal>> allProofSteps = this.folbcask(KB, ansHandler, goals, new HashMap<Variable, Term>());
        ansHandler.setAllProofSteps(allProofSteps);
        return ansHandler;
    }

    private List<List<ProofStepBwChGoal>> folbcask(FOLKnowledgeBase KB, BCAskAnswerHandler ansHandler, List<Literal> goals, Map<Variable, Term> theta) {
        ArrayList<List<ProofStepBwChGoal>> thisLevelProofSteps = new ArrayList<List<ProofStepBwChGoal>>();
        if (goals.isEmpty()) {
            thisLevelProofSteps.add(new ArrayList());
            return thisLevelProofSteps;
        }
        Literal qDelta = KB.subst(theta, goals.get(0));
        for (Clause r : KB.getAllDefiniteClauses()) {
            Map<Variable, Term> thetaDelta = KB.unify((r = KB.standardizeApart(r)).getPositiveLiterals().get(0).getAtomicSentence(), qDelta.getAtomicSentence());
            if (null == thetaDelta) continue;
            ArrayList<Literal> newGoals = new ArrayList<Literal>(r.getNegativeLiterals());
            newGoals.addAll(goals.subList(1, goals.size()));
            Map<Variable, Term> composed = this.compose(KB, thetaDelta, theta);
            List<List<ProofStepBwChGoal>> lowerLevelProofSteps = this.folbcask(KB, ansHandler, newGoals, composed);
            ansHandler.addProofStep(lowerLevelProofSteps, r, qDelta, composed);
            thisLevelProofSteps.addAll(lowerLevelProofSteps);
        }
        return thisLevelProofSteps;
    }

    private Map<Variable, Term> compose(FOLKnowledgeBase KB, Map<Variable, Term> theta1, Map<Variable, Term> theta2) {
        HashMap<Variable, Term> composed = new HashMap<Variable, Term>();
        for (Variable v : theta1.keySet()) {
            composed.put(v, KB.subst(theta2, theta1.get(v)));
        }
        for (Variable v : theta2.keySet()) {
            if (theta1.containsKey(v)) continue;
            composed.put(v, theta2.get(v));
        }
        return this.cascadeSubstitutions(KB, composed);
    }

    private Map<Variable, Term> cascadeSubstitutions(FOLKnowledgeBase KB, Map<Variable, Term> theta) {
        for (Variable v : theta.keySet()) {
            Term t = theta.get(v);
            theta.put(v, KB.subst(theta, t));
        }
        return theta;
    }

    class BCAskAnswerHandler
    implements InferenceResult {
        private List<Proof> proofs = new ArrayList<Proof>();

        @Override
        public boolean isPossiblyFalse() {
            return this.proofs.size() == 0;
        }

        @Override
        public boolean isTrue() {
            return this.proofs.size() > 0;
        }

        @Override
        public boolean isUnknownDueToTimeout() {
            return false;
        }

        @Override
        public boolean isPartialResultDueToTimeout() {
            return false;
        }

        @Override
        public List<Proof> getProofs() {
            return this.proofs;
        }

        public void setAllProofSteps(List<List<ProofStepBwChGoal>> allProofSteps) {
            for (List<ProofStepBwChGoal> steps : allProofSteps) {
                ProofStepBwChGoal lastStep = steps.get(steps.size() - 1);
                Map<Variable, Term> theta = lastStep.getBindings();
                this.proofs.add(new ProofFinal(lastStep, theta));
            }
        }

        public void addProofStep(List<List<ProofStepBwChGoal>> currentLevelProofSteps, Clause toProve, Literal currentGoal, Map<Variable, Term> bindings) {
            if (currentLevelProofSteps.size() > 0) {
                ProofStepBwChGoal predecessor = new ProofStepBwChGoal(toProve, currentGoal, bindings);
                for (List<ProofStepBwChGoal> steps : currentLevelProofSteps) {
                    if (steps.size() > 0) {
                        steps.get(0).setPredecessor(predecessor);
                    }
                    steps.add(0, predecessor);
                }
            }
        }
    }
}

