/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol;

import aima.logic.fol.SubstVisitor;
import aima.logic.fol.VariableCollector;
import aima.logic.fol.parsing.ast.FOLNode;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Unifier {
    private static SubstVisitor _substVisitor = new SubstVisitor();
    private static VariableCollector _variableCollector = new VariableCollector();

    public Map<Variable, Term> unify(FOLNode x, FOLNode y) {
        return this.unify(x, y, new LinkedHashMap<Variable, Term>());
    }

    public Map<Variable, Term> unify(FOLNode x, FOLNode y, Map<Variable, Term> theta) {
        if (theta == null) {
            return null;
        }
        if (x.equals(y)) {
            return theta;
        }
        if (x instanceof Variable) {
            return this.unifyVar((Variable)x, y, theta);
        }
        if (y instanceof Variable) {
            return this.unifyVar((Variable)y, x, theta);
        }
        if (this.isCompound(x) && this.isCompound(y)) {
            return this.unify(this.args(x), this.args(y), this.unifyOps(this.op(x), this.op(y), theta));
        }
        return null;
    }

    public Map<Variable, Term> unify(List<? extends FOLNode> x, List<? extends FOLNode> y, Map<Variable, Term> theta) {
        if (theta == null) {
            return null;
        }
        if (x.size() != y.size()) {
            return null;
        }
        if (x.size() == 0 && y.size() == 0) {
            return theta;
        }
        if (x.size() == 1 && y.size() == 1) {
            return this.unify(x.get(0), y.get(0), theta);
        }
        return this.unify(x.subList(1, x.size()), y.subList(1, y.size()), this.unify(x.get(0), y.get(0), theta));
    }

    protected boolean occurCheck(Map<Variable, Term> theta, Variable var, FOLNode x) {
        if (x instanceof Function) {
            Set<Variable> varsToCheck = _variableCollector.collectAllVariables((Function)x);
            if (varsToCheck.contains(var)) {
                return true;
            }
            return this.cascadeOccurCheck(theta, var, varsToCheck, new HashSet<Variable>(varsToCheck));
        }
        return false;
    }

    private Map<Variable, Term> unifyVar(Variable var, FOLNode x, Map<Variable, Term> theta) {
        if (!Term.class.isInstance(x)) {
            return null;
        }
        if (theta.keySet().contains(var)) {
            return this.unify(theta.get(var), x, theta);
        }
        if (theta.keySet().contains(x)) {
            return this.unify(var, theta.get(x), theta);
        }
        if (this.occurCheck(theta, var, x)) {
            return null;
        }
        this.cascadeSubstitution(theta, var, (Term)x);
        return theta;
    }

    private Map<Variable, Term> unifyOps(String x, String y, Map<Variable, Term> theta) {
        if (theta == null) {
            return null;
        }
        if (x.equals(y)) {
            return theta;
        }
        return null;
    }

    private List<? extends FOLNode> args(FOLNode x) {
        return x.getArgs();
    }

    private String op(FOLNode x) {
        return x.getSymbolicName();
    }

    private boolean isCompound(FOLNode x) {
        return x.isCompound();
    }

    private boolean cascadeOccurCheck(Map<Variable, Term> theta, Variable var, Set<Variable> varsToCheck, Set<Variable> varsCheckedAlready) {
        HashSet<Variable> nextLevelToCheck = new HashSet<Variable>();
        for (Variable v : varsToCheck) {
            Term t = theta.get(v);
            if (null == t) continue;
            if (t.equals(var)) {
                return true;
            }
            if (!(t instanceof Function)) continue;
            Set<Variable> indirectvars = _variableCollector.collectAllVariables((Function)t);
            if (indirectvars.contains(var)) {
                return true;
            }
            for (Variable iv : indirectvars) {
                if (varsCheckedAlready.contains(iv)) continue;
                nextLevelToCheck.add(iv);
            }
        }
        if (nextLevelToCheck.size() > 0) {
            varsCheckedAlready.addAll(nextLevelToCheck);
            return this.cascadeOccurCheck(theta, var, nextLevelToCheck, varsCheckedAlready);
        }
        return false;
    }

    private void cascadeSubstitution(Map<Variable, Term> theta, Variable var, Term x) {
        theta.put(var, x);
        for (Variable v : theta.keySet()) {
            Term t = theta.get(v);
            theta.put(v, _substVisitor.subst(theta, t));
        }
    }
}

