/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.common;

import aima.logic.common.Token;
import java.io.Reader;
import java.io.StringReader;

public abstract class Lexer {
    protected Reader input;
    protected int lookAhead = 1;
    protected int[] lookAheadBuffer;

    protected abstract Token nextToken();

    public void setInput(String inputString) {
        this.lookAheadBuffer = new int[this.lookAhead];
        this.input = new StringReader(inputString);
        this.fillLookAheadBuffer();
    }

    protected void fillLookAheadBuffer() {
        try {
            this.lookAheadBuffer[0] = (char)this.input.read();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected char lookAhead(int position) {
        return (char)this.lookAheadBuffer[position - 1];
    }

    protected boolean isEndOfFile(int i) {
        return -1 == i;
    }

    protected void loadNextCharacterFromInput() {
        boolean eofEncountered = false;
        for (int i = 0; i < this.lookAhead - 1; ++i) {
            this.lookAheadBuffer[i] = this.lookAheadBuffer[i + 1];
            if (!this.isEndOfFile(this.lookAheadBuffer[i])) continue;
            eofEncountered = true;
            break;
        }
        if (!eofEncountered) {
            try {
                this.lookAheadBuffer[this.lookAhead - 1] = this.input.read();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void consume() {
        this.loadNextCharacterFromInput();
    }

    public void clear() {
        this.input = null;
        this.lookAheadBuffer = null;
    }
}

