/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.reinforcement;

import aima.probability.Randomizer;
import aima.probability.decision.MDP;
import aima.probability.decision.MDPPerception;

public abstract class MDPAgent<STATE_TYPE, ACTION_TYPE> {
    protected MDP<STATE_TYPE, ACTION_TYPE> mdp;
    protected STATE_TYPE currentState;
    protected Double currentReward;
    protected STATE_TYPE previousState;
    protected ACTION_TYPE previousAction;

    public MDPAgent(MDP<STATE_TYPE, ACTION_TYPE> mdp) {
        this.mdp = mdp;
        this.currentState = mdp.getInitialState();
        this.currentReward = mdp.getRewardFor(this.currentState);
    }

    public MDPPerception<STATE_TYPE> execute(ACTION_TYPE action, Randomizer r) {
        MDPPerception<STATE_TYPE> perception = this.mdp.execute(this.currentState, action, r);
        this.updateFromPerception(perception);
        return perception;
    }

    public void updateFromPerception(MDPPerception<STATE_TYPE> perception) {
        this.currentState = perception.getState();
        this.currentReward = perception.getReward();
    }

    public void executeTrial(Randomizer r) {
        this.currentState = this.mdp.getInitialState();
        this.currentReward = this.mdp.getRewardFor(this.mdp.getInitialState());
        this.previousState = null;
        this.previousAction = null;
        MDPPerception<STATE_TYPE> perception = new MDPPerception<STATE_TYPE>(this.currentState, this.currentReward);
        ACTION_TYPE action = null;
        do {
            if ((action = (ACTION_TYPE)this.decideAction(perception)) == null) continue;
            perception = this.execute(action, r);
        } while (action != null);
    }

    public abstract ACTION_TYPE decideAction(MDPPerception<STATE_TYPE> var1);

    public Double getCurrentReward() {
        return this.currentReward;
    }

    public void setCurrentReward(Double currentReward) {
        this.currentReward = currentReward;
    }

    public ACTION_TYPE getPreviousAction() {
        return this.previousAction;
    }

    public void setPreviousAction(ACTION_TYPE previousAction) {
        this.previousAction = previousAction;
    }

    public STATE_TYPE getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(STATE_TYPE previousState) {
        this.previousState = previousState;
    }

    public STATE_TYPE getCurrentState() {
        return this.currentState;
    }
}

