/*
 * Decompiled with CFR 0.152.
 */
package aima.learning.framework;

import aima.learning.framework.Attribute;
import aima.learning.framework.AttributeSpecification;
import aima.learning.framework.StringAttribute;
import java.util.Arrays;
import java.util.List;

public class StringAttributeSpecification
implements AttributeSpecification {
    String attributeName;
    List<String> attributePossibleValues;

    public StringAttributeSpecification(String attributeName, List<String> attributePossibleValues) {
        this.attributeName = attributeName;
        this.attributePossibleValues = attributePossibleValues;
    }

    public StringAttributeSpecification(String attributeName, String[] attributePossibleValues) {
        this(attributeName, Arrays.asList(attributePossibleValues));
    }

    @Override
    public boolean isValid(String value) {
        return this.attributePossibleValues.contains(value);
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    public List<String> possibleAttributeValues() {
        return this.attributePossibleValues;
    }

    @Override
    public Attribute createAttribute(String rawValue) {
        return new StringAttribute(rawValue, this);
    }
}

