/*
 * Decompiled with CFR 0.152.
 */
package fxgraph;

import fxgraph.FXGraph;
import fxgraph.FXNode;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import mcgraphresolver.utils.SharePreferencesHandler;
import mcgraphresolver.utils.Utils;

public class FXNodeTree
extends FXNode
implements Comparable {
    private SharePreferencesHandler sharePreferencesHandler = new SharePreferencesHandler();
    private static Color GENERIC_NODE_COLOR = Color.valueOf((String)"#00b8d4");
    private static Color SOURCE_NODE_COLOR = Color.valueOf((String)"#d50000");
    private static Color DESTINATION_NODE_COLOR = Color.valueOf((String)"#00c853");
    private Color defaultColor = Color.valueOf((String)"#00b8d4");
    private int id;
    private VBox vBox;
    private FXGraph graphOwner;
    private Button btnNode;
    private Label lblF;
    private Label lblOrder;
    private nodeType type = nodeType.GENERIC_NODE;

    @Override
    public void onSelect() {
        if (this.defaultColor != null) {
            this.getBtnNode().setStyle("-fx-background-color: " + Utils.toRGBCode(Utils.darkerColor(this.defaultColor, 0.5)) + ";");
        }
    }

    @Override
    public void onDeselect() {
        if (this.defaultColor != null) {
            this.getBtnNode().setStyle("-fx-background-color: " + Utils.toRGBCode(this.defaultColor) + ";");
        }
    }

    public FXNodeTree(int id, String label, String labelF, String order, FXGraph graphOwner) {
        this.id = id;
        this.vBox = this.createVBox(label, labelF, order);
        this.graphOwner = graphOwner;
        this.setNode((Node)this.vBox);
        SOURCE_NODE_COLOR = Color.valueOf((String)this.sharePreferencesHandler.getColorResource("color_source_node", "#d50000"));
        DESTINATION_NODE_COLOR = Color.valueOf((String)this.sharePreferencesHandler.getColorResource("color_destination_node", "#00c853"));
        GENERIC_NODE_COLOR = Color.valueOf((String)this.sharePreferencesHandler.getColorResource("color_generic_node", "#00b8d4"));
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public VBox getVBox() {
        return this.vBox;
    }

    public void setVBox(VBox vBox) {
        this.vBox = vBox;
    }

    public Button getBtnNode() {
        return this.btnNode;
    }

    public void setBtnNode(Button btnNode) {
        this.btnNode = btnNode;
    }

    public Label getLblF() {
        return this.lblF;
    }

    public void setLblF(Label lblF) {
        this.lblF = lblF;
    }

    public Label getLblOrder() {
        return this.lblOrder;
    }

    public void setLblOrder(Label lblOrder) {
        this.lblOrder = lblOrder;
    }

    public void setTextLabel(String newTextLabel) {
        this.btnNode.setText(newTextLabel);
    }

    public void setEstimate(double newEstimate) {
        this.lblF.setText(String.valueOf(newEstimate));
    }

    public void setOrder(String newOrder) {
        this.lblOrder.setText(String.format("[%s]", newOrder));
    }

    public void setBackgroundColor(Color color) {
        this.defaultColor = color;
        this.btnNode.setStyle("-fx-background-color: " + Utils.toRGBCode(color) + ";");
    }

    public nodeType getType() {
        return this.type;
    }

    public void setType(nodeType type) {
        this.type = type;
    }

    public boolean equals(Object other) {
        if (!(other instanceof FXNodeTree)) {
            return false;
        }
        FXNodeTree fxNodeGeneric = (FXNodeTree)other;
        return this.btnNode.getText().equals(fxNodeGeneric.getBtnNode().getText());
    }

    private VBox createVBox(String label, String labelF, String order) {
        VBox vBox = new VBox();
        HBox hBox = new HBox();
        this.lblF = new Label(labelF);
        this.lblF.setStyle("-fx-font-size: 13px");
        this.lblOrder = new Label(String.format("%s", order));
        this.lblOrder.setStyle("-fx-font-size: 15px; -fx-border-color: black; -fx-padding: 3px;");
        if (order.equals("/")) {
            this.lblOrder.setVisible(false);
        }
        this.btnNode = new Button(label);
        this.btnNode.getStyleClass().add((Object)"custom-jfx-button-fab-node");
        this.btnNode.setStyle("-fx-background-color: #00b8d4;");
        this.lblF.setTextFill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_estimate", Utils.toRGBCode(Color.BLACK))));
        this.lblOrder.setTextFill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_source_node", "#d50000")));
        this.btnNode.setTextFill((Paint)Color.web((String)this.sharePreferencesHandler.getColorResource("color_label_inside_node", Utils.toRGBCode(Color.WHITE))));
        this.btnNode.setMouseTransparent(true);
        vBox.setAlignment(Pos.CENTER);
        vBox.setSpacing(5.0);
        hBox.setAlignment(Pos.CENTER);
        hBox.setSpacing(5.0);
        vBox.setPadding(new Insets(2.0));
        hBox.getChildren().add((Object)this.btnNode);
        hBox.getChildren().add((Object)this.lblOrder);
        vBox.getChildren().add((Object)this.lblF);
        vBox.getChildren().add((Object)hBox);
        vBox.requestFocus();
        return vBox;
    }

    public int compareTo(Object object) {
        if (!(object instanceof FXNodeTree)) {
            return 0;
        }
        FXNodeTree fxNodeGeneric = (FXNodeTree)object;
        return this.btnNode.getText().compareToIgnoreCase(fxNodeGeneric.getBtnNode().getText());
    }

    public String toString() {
        return "FXNodeGeneric{vBox=" + this.vBox + ", btnNode=" + this.btnNode + ", lblF=" + this.lblF + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static enum nodeType {
        GENERIC_NODE,
        SOURCE_NODE,
        DESTINATION_NODE;

    }
}

