/*
 * Decompiled with CFR 0.152.
 */
package aima.test.utiltest;

import aima.util.MixedRadixNumber;
import junit.framework.TestCase;

public class MixedRadixNumberTest
extends TestCase {
    public void testInvalidRadixs() {
        try {
            new MixedRadixNumber(100L, new int[]{1, 0, -1});
            MixedRadixNumberTest.fail("Should have thrown an Illegal Argument Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testInvalidMaxValue() {
        try {
            new MixedRadixNumber(100L, new int[]{3, 3, 3});
            MixedRadixNumberTest.fail("Should have thrown an Illegal Argument Exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAllowedMaxValue() {
        MixedRadixNumberTest.assertEquals(15L, new MixedRadixNumber(0L, new int[]{2, 2, 2, 2}).getMaxAllowedValue());
        MixedRadixNumberTest.assertEquals(80L, new MixedRadixNumber(0L, new int[]{3, 3, 3, 3}).getMaxAllowedValue());
        MixedRadixNumberTest.assertEquals(5L, new MixedRadixNumber(0L, new int[]{3, 2}).getMaxAllowedValue());
        MixedRadixNumberTest.assertEquals(35L, new MixedRadixNumber(0L, new int[]{3, 3, 2, 2}).getMaxAllowedValue());
        MixedRadixNumberTest.assertEquals(359L, new MixedRadixNumber(0L, new int[]{3, 4, 5, 6}).getMaxAllowedValue());
        MixedRadixNumberTest.assertEquals(359L, new MixedRadixNumber(0L, new int[]{6, 5, 4, 3}).getMaxAllowedValue());
    }

    public void testIncrement() {
        MixedRadixNumber mrn = new MixedRadixNumber(0L, new int[]{3, 2});
        int i = 0;
        while (mrn.increment()) {
            ++i;
        }
        MixedRadixNumberTest.assertEquals((long)i, mrn.getMaxAllowedValue());
    }

    public void testDecrement() {
        MixedRadixNumber mrn = new MixedRadixNumber(5L, new int[]{3, 2});
        int i = 0;
        while (mrn.decrement()) {
            ++i;
        }
        MixedRadixNumberTest.assertEquals((long)i, mrn.getMaxAllowedValue());
    }

    public void testCurrentNumberalValue() {
        MixedRadixNumber mrn = new MixedRadixNumber(0L, new int[]{3, 3, 2, 2});
        MixedRadixNumberTest.assertEquals(0, mrn.getCurrentNumeralValue(0));
        MixedRadixNumberTest.assertEquals(0, mrn.getCurrentNumeralValue(1));
        MixedRadixNumberTest.assertEquals(0, mrn.getCurrentNumeralValue(2));
        MixedRadixNumberTest.assertEquals(0, mrn.getCurrentNumeralValue(3));
        mrn = new MixedRadixNumber(35L, new int[]{3, 3, 2, 2});
        MixedRadixNumberTest.assertEquals(2, mrn.getCurrentNumeralValue(0));
        MixedRadixNumberTest.assertEquals(2, mrn.getCurrentNumeralValue(1));
        MixedRadixNumberTest.assertEquals(1, mrn.getCurrentNumeralValue(2));
        MixedRadixNumberTest.assertEquals(1, mrn.getCurrentNumeralValue(3));
        mrn = new MixedRadixNumber(25L, new int[]{3, 3, 2, 2});
        MixedRadixNumberTest.assertEquals(1, mrn.getCurrentNumeralValue(0));
        MixedRadixNumberTest.assertEquals(2, mrn.getCurrentNumeralValue(1));
        MixedRadixNumberTest.assertEquals(0, mrn.getCurrentNumeralValue(2));
        MixedRadixNumberTest.assertEquals(1, mrn.getCurrentNumeralValue(3));
        mrn = new MixedRadixNumber(17L, new int[]{3, 3, 2, 2});
        MixedRadixNumberTest.assertEquals(2, mrn.getCurrentNumeralValue(0));
        MixedRadixNumberTest.assertEquals(2, mrn.getCurrentNumeralValue(1));
        MixedRadixNumberTest.assertEquals(1, mrn.getCurrentNumeralValue(2));
        MixedRadixNumberTest.assertEquals(0, mrn.getCurrentNumeralValue(3));
        mrn = new MixedRadixNumber(8L, new int[]{3, 3, 2, 2});
        MixedRadixNumberTest.assertEquals(2, mrn.getCurrentNumeralValue(0));
        MixedRadixNumberTest.assertEquals(2, mrn.getCurrentNumeralValue(1));
        MixedRadixNumberTest.assertEquals(0, mrn.getCurrentNumeralValue(2));
        MixedRadixNumberTest.assertEquals(0, mrn.getCurrentNumeralValue(3));
        mrn = new MixedRadixNumber(359L, new int[]{3, 4, 5, 6});
        MixedRadixNumberTest.assertEquals(2, mrn.getCurrentNumeralValue(0));
        MixedRadixNumberTest.assertEquals(3, mrn.getCurrentNumeralValue(1));
        MixedRadixNumberTest.assertEquals(4, mrn.getCurrentNumeralValue(2));
        MixedRadixNumberTest.assertEquals(5, mrn.getCurrentNumeralValue(3));
        mrn = new MixedRadixNumber(359L, new int[]{6, 5, 4, 3});
        MixedRadixNumberTest.assertEquals(5, mrn.getCurrentNumeralValue(0));
        MixedRadixNumberTest.assertEquals(4, mrn.getCurrentNumeralValue(1));
        MixedRadixNumberTest.assertEquals(3, mrn.getCurrentNumeralValue(2));
        MixedRadixNumberTest.assertEquals(2, mrn.getCurrentNumeralValue(3));
    }
}

