/*
 * Decompiled with CFR 0.152.
 */
package aima.test.search.online;

import aima.basic.BasicEnvironmentView;
import aima.search.framework.HeuristicFunction;
import aima.search.map.BidirectionalMapProblem;
import aima.search.map.ExtendableMap;
import aima.search.map.MapEnvironment;
import aima.search.online.LRTAStarAgent;
import junit.framework.TestCase;

public class LRTAStarAgentTest
extends TestCase {
    ExtendableMap aMap;
    StringBuffer envChanges;
    HeuristicFunction hf;

    @Override
    public void setUp() {
        this.aMap = new ExtendableMap();
        this.aMap.addBidirectionalLink("A", "B", 4.0);
        this.aMap.addBidirectionalLink("B", "C", 4.0);
        this.aMap.addBidirectionalLink("C", "D", 4.0);
        this.aMap.addBidirectionalLink("D", "E", 4.0);
        this.aMap.addBidirectionalLink("E", "F", 4.0);
        this.hf = new HeuristicFunction(){

            @Override
            public double getHeuristicValue(Object state) {
                return 1.0;
            }
        };
        this.envChanges = new StringBuffer();
    }

    public void testAlreadyAtGoal() {
        MapEnvironment me = new MapEnvironment(this.aMap);
        LRTAStarAgent agent = new LRTAStarAgent(new BidirectionalMapProblem(me.getMap(), "A", "A", this.hf));
        me.addAgent(agent, "A");
        me.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                LRTAStarAgentTest.this.envChanges.append(command).append("->");
            }
        });
        me.stepUntilDone();
        LRTAStarAgentTest.assertEquals("NoOP->", this.envChanges.toString());
    }

    public void testNormalSearch() {
        MapEnvironment me = new MapEnvironment(this.aMap);
        LRTAStarAgent agent = new LRTAStarAgent(new BidirectionalMapProblem(me.getMap(), "A", "F", this.hf));
        me.addAgent(agent, "A");
        me.registerView(new BasicEnvironmentView(){

            @Override
            public void envChanged(String command) {
                LRTAStarAgentTest.this.envChanges.append(command).append("->");
            }
        });
        me.stepUntilDone();
        LRTAStarAgentTest.assertEquals("B->A->B->C->B->C->D->C->D->E->D->E->F->NoOP->", this.envChanges.toString());
    }

    public void testNoPath() {
    }
}

