/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.parser;

import aima.logic.common.Token;
import aima.logic.propositional.parsing.PELexer;
import junit.framework.TestCase;

public class PELexerTest
extends TestCase {
    public void testLexBasicExpression() {
        PELexer pelexer = new PELexer();
        pelexer.setInput("(P)");
        PELexerTest.assertEquals(new Token(2, "("), pelexer.nextToken());
        PELexerTest.assertEquals(new Token(1, "P"), pelexer.nextToken());
        PELexerTest.assertEquals(new Token(3, ")"), pelexer.nextToken());
        PELexerTest.assertEquals(new Token(9999, "EOI"), pelexer.nextToken());
    }

    public void testLexNotExpression() {
        PELexer pelexer = new PELexer();
        pelexer.setInput("(NOT P)");
        PELexerTest.assertEquals(new Token(2, "("), pelexer.nextToken());
        PELexerTest.assertEquals(new Token(5, "NOT"), pelexer.nextToken());
        PELexerTest.assertEquals(new Token(1, "P"), pelexer.nextToken());
        PELexerTest.assertEquals(new Token(3, ")"), pelexer.nextToken());
        PELexerTest.assertEquals(new Token(9999, "EOI"), pelexer.nextToken());
    }

    public void testLexImpliesExpression() {
        PELexer pelexer = new PELexer();
        pelexer.setInput("(P => Q)");
        PELexerTest.assertEquals(new Token(2, "("), pelexer.nextToken());
        PELexerTest.assertEquals(new Token(1, "P"), pelexer.nextToken());
        PELexerTest.assertEquals(new Token(5, "=>"), pelexer.nextToken());
    }

    public void testLexBiCOnditionalExpression() {
        PELexer pelexer = new PELexer();
        pelexer.setInput("(B11 <=> (P12 OR P21))");
        PELexerTest.assertEquals(new Token(2, "("), pelexer.nextToken());
        PELexerTest.assertEquals(new Token(1, "B11"), pelexer.nextToken());
        PELexerTest.assertEquals(new Token(5, "<=>"), pelexer.nextToken());
    }
}

