/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.prop.algorithms;

import aima.logic.propositional.algorithms.KnowledgeBase;
import junit.framework.TestCase;

public class KnowledgeBaseTest
extends TestCase {
    private KnowledgeBase kb;

    @Override
    public void setUp() {
        this.kb = new KnowledgeBase();
    }

    public void testTellInsertsSentence() {
        this.kb.tell("(A AND B)");
        KnowledgeBaseTest.assertEquals(1, this.kb.size());
    }

    public void testTellDoesNotInsertSameSentenceTwice() {
        this.kb.tell("(A AND B)");
        KnowledgeBaseTest.assertEquals(1, this.kb.size());
        this.kb.tell("(A AND B)");
        KnowledgeBaseTest.assertEquals(1, this.kb.size());
    }

    public void testEmptyKnowledgeBaseIsAnEmptyString() {
        KnowledgeBaseTest.assertEquals("", this.kb.toString());
    }

    public void testKnowledgeBaseWithOneSentenceToString() {
        this.kb.tell("(A AND B)");
        KnowledgeBaseTest.assertEquals(" ( A AND B )", this.kb.toString());
    }

    public void testKnowledgeBaseWithTwoSentencesToString() {
        this.kb.tell("(A AND B)");
        this.kb.tell("(C AND D)");
        KnowledgeBaseTest.assertEquals(" (  ( A AND B ) AND  ( C AND D ) )", this.kb.toString());
    }

    public void testKnowledgeBaseWithThreeSentencesToString() {
        this.kb.tell("(A AND B)");
        this.kb.tell("(C AND D)");
        this.kb.tell("(E AND F)");
        KnowledgeBaseTest.assertEquals(" (  (  ( A AND B ) AND  ( C AND D ) ) AND  ( E AND F ) )", this.kb.toString());
    }
}

