/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.common.Token;
import aima.logic.fol.domain.FOLDomain;
import aima.logic.fol.parsing.FOLLexer;
import junit.framework.TestCase;

public class FOLLexerTest
extends TestCase {
    FOLLexer lexer;

    @Override
    public void setUp() {
        FOLDomain domain = new FOLDomain();
        domain.addConstant("P");
        domain.addConstant("John");
        domain.addConstant("Saladin");
        domain.addFunction("LeftLeg");
        domain.addFunction("BrotherOf");
        domain.addFunction("EnemyOf");
        domain.addPredicate("HasColor");
        domain.addPredicate("King");
        this.lexer = new FOLLexer(domain);
    }

    public void testLexBasicExpression() {
        this.lexer.setInput("( P )");
        FOLLexerTest.assertEquals(new Token(2, "("), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(10, "P"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(3, ")"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(9999, "EOI"), this.lexer.nextToken());
    }

    public void testConnectors() {
        this.lexer.setInput(" p  AND q");
        FOLLexerTest.assertEquals(new Token(9, "p"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(5, "AND"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(9, "q"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(9999, "EOI"), this.lexer.nextToken());
    }

    public void testFunctions() {
        this.lexer.setInput(" LeftLeg(q)");
        FOLLexerTest.assertEquals(new Token(8, "LeftLeg"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(2, "("), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(9, "q"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(3, ")"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(9999, "EOI"), this.lexer.nextToken());
    }

    public void testPredicate() {
        this.lexer.setInput(" HasColor(r)");
        FOLLexerTest.assertEquals(new Token(7, "HasColor"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(2, "("), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(9, "r"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(3, ")"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(9999, "EOI"), this.lexer.nextToken());
    }

    public void testMultiArgPredicate() {
        this.lexer.setInput(" King(x,y)");
        FOLLexerTest.assertEquals(new Token(7, "King"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(2, "("), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(9, "x"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(4, ","), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(9, "y"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(3, ")"), this.lexer.nextToken());
    }

    public void testQuantifier() {
        this.lexer.setInput("FORALL x,y");
        FOLLexerTest.assertEquals(new Token(6, "FORALL"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(9, "x"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(4, ","), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(9, "y"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(9999, "EOI"), this.lexer.nextToken());
    }

    public void testTermEquality() {
        this.lexer.setInput("BrotherOf(John) = EnemyOf(Saladin)");
        FOLLexerTest.assertEquals(new Token(8, "BrotherOf"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(2, "("), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(10, "John"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(3, ")"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(13, "="), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(8, "EnemyOf"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(2, "("), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(10, "Saladin"), this.lexer.nextToken());
        FOLLexerTest.assertEquals(new Token(3, ")"), this.lexer.nextToken());
    }
}

