/*
 * Decompiled with CFR 0.152.
 */
package aima.test.logictest.foltest;

import aima.logic.fol.inference.InferenceProcedure;
import aima.logic.fol.inference.InferenceResult;
import aima.logic.fol.inference.proof.Proof;
import aima.logic.fol.kb.FOLKnowledgeBase;
import aima.logic.fol.kb.FOLKnowledgeBaseFactory;
import aima.logic.fol.parsing.ast.Constant;
import aima.logic.fol.parsing.ast.Function;
import aima.logic.fol.parsing.ast.NotSentence;
import aima.logic.fol.parsing.ast.Predicate;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.TermEquality;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.Map;
import junit.framework.TestCase;

public abstract class CommonFOLInferenceProcedureTests
extends TestCase {
    protected void testDefiniteClauseKBKingsQueryCriminalXFalse(InferenceProcedure infp) {
        FOLKnowledgeBase kkb = FOLKnowledgeBaseFactory.createKingsKnowledgeBase(infp);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Variable("x"));
        Predicate query = new Predicate("Criminal", terms);
        InferenceResult answer = kkb.ask(query);
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        CommonFOLInferenceProcedureTests.assertTrue(answer.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().size());
    }

    protected void testDefiniteClauseKBKingsQueryRichardEvilFalse(InferenceProcedure infp) {
        FOLKnowledgeBase kkb = FOLKnowledgeBaseFactory.createKingsKnowledgeBase(infp);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Constant("Richard"));
        Predicate query = new Predicate("Evil", terms);
        InferenceResult answer = kkb.ask(query);
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        CommonFOLInferenceProcedureTests.assertTrue(answer.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().size());
    }

    protected void testDefiniteClauseKBKingsQueryJohnEvilSucceeds(InferenceProcedure infp) {
        FOLKnowledgeBase kkb = FOLKnowledgeBaseFactory.createKingsKnowledgeBase(infp);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Constant("John"));
        Predicate query = new Predicate("Evil", terms);
        InferenceResult answer = kkb.ask(query);
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue(answer.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().size());
        CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().get(0).getAnswerBindings().size());
    }

    protected void testDefiniteClauseKBKingsQueryEvilXReturnsJohnSucceeds(InferenceProcedure infp) {
        FOLKnowledgeBase kkb = FOLKnowledgeBaseFactory.createKingsKnowledgeBase(infp);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Variable("x"));
        Predicate query = new Predicate("Evil", terms);
        InferenceResult answer = kkb.ask(query);
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue(answer.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().size());
        CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().get(0).getAnswerBindings().size());
        CommonFOLInferenceProcedureTests.assertEquals(new Constant("John"), answer.getProofs().get(0).getAnswerBindings().get(new Variable("x")));
    }

    protected void testDefiniteClauseKBKingsQueryKingXReturnsJohnAndRichardSucceeds(InferenceProcedure infp) {
        FOLKnowledgeBase kkb = FOLKnowledgeBaseFactory.createKingsKnowledgeBase(infp);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Variable("x"));
        Predicate query = new Predicate("King", terms);
        InferenceResult answer = kkb.ask(query);
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue(answer.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue(2 == answer.getProofs().size());
        CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().get(0).getAnswerBindings().size());
        CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().get(1).getAnswerBindings().size());
        boolean gotRichard = false;
        boolean gotJohn = false;
        Constant cJohn = new Constant("John");
        Constant cRichard = new Constant("Richard");
        for (Proof p : answer.getProofs()) {
            Map<Variable, Term> ans = p.getAnswerBindings();
            CommonFOLInferenceProcedureTests.assertEquals(1, ans.size());
            if (cJohn.equals(ans.get(new Variable("x")))) {
                gotJohn = true;
            }
            if (!cRichard.equals(ans.get(new Variable("x")))) continue;
            gotRichard = true;
        }
        CommonFOLInferenceProcedureTests.assertTrue(gotJohn);
        CommonFOLInferenceProcedureTests.assertTrue(gotRichard);
    }

    protected void testDefiniteClauseKBWeaponsQueryCriminalXReturnsWestSucceeds(InferenceProcedure infp) {
        FOLKnowledgeBase wkb = FOLKnowledgeBaseFactory.createWeaponsKnowledgeBase(infp);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Variable("x"));
        Predicate query = new Predicate("Criminal", terms);
        InferenceResult answer = wkb.ask(query);
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue(answer.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().size());
        CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().get(0).getAnswerBindings().size());
        CommonFOLInferenceProcedureTests.assertEquals(new Constant("West"), answer.getProofs().get(0).getAnswerBindings().get(new Variable("x")));
    }

    protected void testHornClauseKBRingOfThievesQuerySkisXReturnsNancyRedBertDrew(InferenceProcedure infp) {
        FOLKnowledgeBase rotkb = FOLKnowledgeBaseFactory.createRingOfThievesKnowledgeBase(infp);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Variable("x"));
        Predicate query = new Predicate("Skis", terms);
        InferenceResult answer = rotkb.ask(query);
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue(answer.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue(answer.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertEquals(4, answer.getProofs().size());
        CommonFOLInferenceProcedureTests.assertEquals(1, answer.getProofs().get(0).getAnswerBindings().size());
        CommonFOLInferenceProcedureTests.assertEquals(1, answer.getProofs().get(1).getAnswerBindings().size());
        CommonFOLInferenceProcedureTests.assertEquals(1, answer.getProofs().get(2).getAnswerBindings().size());
        CommonFOLInferenceProcedureTests.assertEquals(1, answer.getProofs().get(3).getAnswerBindings().size());
        ArrayList<Constant> expected = new ArrayList<Constant>();
        expected.add(new Constant("Nancy"));
        expected.add(new Constant("Red"));
        expected.add(new Constant("Bert"));
        expected.add(new Constant("Drew"));
        for (Proof p : answer.getProofs()) {
            expected.remove(p.getAnswerBindings().get(new Variable("x")));
        }
        CommonFOLInferenceProcedureTests.assertEquals(0, expected.size());
    }

    protected void testFullFOLKBLovesAnimalQueryKillsCuriosityTunaSucceeds(InferenceProcedure infp, boolean expectedToTimeOut) {
        FOLKnowledgeBase akb = FOLKnowledgeBaseFactory.createLovesAnimalKnowledgeBase(infp);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Constant("Curiosity"));
        terms.add(new Constant("Tuna"));
        Predicate query = new Predicate("Kills", terms);
        InferenceResult answer = akb.ask(query);
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        if (expectedToTimeOut) {
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertTrue(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().size());
        } else {
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertTrue(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().size());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().get(0).getAnswerBindings().size());
        }
    }

    protected void testFullFOLKBLovesAnimalQueryNotKillsJackTunaSucceeds(InferenceProcedure infp, boolean expectedToTimeOut) {
        FOLKnowledgeBase akb = FOLKnowledgeBaseFactory.createLovesAnimalKnowledgeBase(infp);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Constant("Jack"));
        terms.add(new Constant("Tuna"));
        NotSentence query = new NotSentence(new Predicate("Kills", terms));
        InferenceResult answer = akb.ask(query);
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        if (expectedToTimeOut) {
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertTrue(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().size());
        } else {
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertTrue(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().size());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().get(0).getAnswerBindings().size());
        }
    }

    protected void testFullFOLKBLovesAnimalQueryKillsJackTunaFalse(InferenceProcedure infp, boolean expectedToTimeOut) {
        FOLKnowledgeBase akb = FOLKnowledgeBaseFactory.createLovesAnimalKnowledgeBase(infp);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Constant("Jack"));
        terms.add(new Constant("Tuna"));
        Predicate query = new Predicate("Kills", terms);
        InferenceResult answer = akb.ask(query);
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        if (expectedToTimeOut) {
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertTrue(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().size());
        } else {
            CommonFOLInferenceProcedureTests.assertTrue(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().size());
        }
    }

    protected void testEqualityAxiomsKBabcAEqualsCSucceeds(InferenceProcedure infp) {
        TermEquality query;
        FOLKnowledgeBase akb = FOLKnowledgeBaseFactory.createABCEqualityKnowledgeBase(infp, true);
        InferenceResult answer = akb.ask(query = new TermEquality(new Constant("A"), new Constant("C")));
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue(answer.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().size());
        CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().get(0).getAnswerBindings().size());
    }

    protected void testEqualityAndSubstitutionAxiomsKBabcdFFASucceeds(InferenceProcedure infp) {
        FOLKnowledgeBase akb = FOLKnowledgeBaseFactory.createABCDEqualityAndSubstitutionKnowledgeBase(infp, true);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Constant("A"));
        Function fa = new Function("F", terms);
        terms = new ArrayList();
        terms.add(fa);
        TermEquality query = new TermEquality(new Function("F", terms), new Constant("A"));
        InferenceResult answer = akb.ask(query);
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue(answer.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().size());
        CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().get(0).getAnswerBindings().size());
    }

    protected void xtestEqualityAndSubstitutionAxiomsKBabcdPDSucceeds(InferenceProcedure infp) {
        FOLKnowledgeBase akb = FOLKnowledgeBaseFactory.createABCDEqualityAndSubstitutionKnowledgeBase(infp, true);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Constant("D"));
        Predicate query = new Predicate("P", terms);
        InferenceResult answer = akb.ask(query);
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
        CommonFOLInferenceProcedureTests.assertTrue(answer.isTrue());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
        CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
        CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().size());
        CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().get(0).getAnswerBindings().size());
    }

    protected void testEqualityAndSubstitutionAxiomsKBabcdPFFASucceeds(InferenceProcedure infp, boolean expectedToTimeOut) {
        FOLKnowledgeBase akb = FOLKnowledgeBaseFactory.createABCDEqualityAndSubstitutionKnowledgeBase(infp, true);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Constant("A"));
        Function fa = new Function("F", terms);
        terms = new ArrayList();
        terms.add(fa);
        Function ffa = new Function("F", terms);
        terms = new ArrayList();
        terms.add(ffa);
        Predicate query = new Predicate("P", terms);
        InferenceResult answer = akb.ask(query);
        if (expectedToTimeOut) {
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertTrue(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().size());
        } else {
            CommonFOLInferenceProcedureTests.assertTrue(null != answer);
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertTrue(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().size());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().get(0).getAnswerBindings().size());
        }
    }

    protected void testEqualityNoAxiomsKBabcAEqualsCSucceeds(InferenceProcedure infp, boolean expectedToFail) {
        TermEquality query;
        FOLKnowledgeBase akb = FOLKnowledgeBaseFactory.createABCEqualityKnowledgeBase(infp, false);
        InferenceResult answer = akb.ask(query = new TermEquality(new Constant("A"), new Constant("C")));
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        if (expectedToFail) {
            CommonFOLInferenceProcedureTests.assertTrue(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().size());
        } else {
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertTrue(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().size());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().get(0).getAnswerBindings().size());
        }
    }

    protected void testEqualityAndSubstitutionNoAxiomsKBabcdFFASucceeds(InferenceProcedure infp, boolean expectedToFail) {
        FOLKnowledgeBase akb = FOLKnowledgeBaseFactory.createABCDEqualityAndSubstitutionKnowledgeBase(infp, false);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Constant("A"));
        Function fa = new Function("F", terms);
        terms = new ArrayList();
        terms.add(fa);
        TermEquality query = new TermEquality(new Function("F", terms), new Constant("A"));
        InferenceResult answer = akb.ask(query);
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        if (expectedToFail) {
            CommonFOLInferenceProcedureTests.assertTrue(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().size());
        } else {
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertTrue(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().size());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().get(0).getAnswerBindings().size());
        }
    }

    protected void testEqualityAndSubstitutionNoAxiomsKBabcdPDSucceeds(InferenceProcedure infp, boolean expectedToFail) {
        FOLKnowledgeBase akb = FOLKnowledgeBaseFactory.createABCDEqualityAndSubstitutionKnowledgeBase(infp, false);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Constant("D"));
        Predicate query = new Predicate("P", terms);
        InferenceResult answer = akb.ask(query);
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        if (expectedToFail) {
            CommonFOLInferenceProcedureTests.assertTrue(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().size());
        } else {
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertTrue(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().size());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().get(0).getAnswerBindings().size());
        }
    }

    protected void testEqualityAndSubstitutionNoAxiomsKBabcdPFFASucceeds(InferenceProcedure infp, boolean expectedToFail) {
        FOLKnowledgeBase akb = FOLKnowledgeBaseFactory.createABCDEqualityAndSubstitutionKnowledgeBase(infp, false);
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(new Constant("A"));
        Function fa = new Function("F", terms);
        terms = new ArrayList();
        terms.add(fa);
        Function ffa = new Function("F", terms);
        terms = new ArrayList();
        terms.add(ffa);
        Predicate query = new Predicate("P", terms);
        InferenceResult answer = akb.ask(query);
        CommonFOLInferenceProcedureTests.assertTrue(null != answer);
        if (expectedToFail) {
            CommonFOLInferenceProcedureTests.assertTrue(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().size());
        } else {
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPossiblyFalse());
            CommonFOLInferenceProcedureTests.assertTrue(answer.isTrue());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isUnknownDueToTimeout());
            CommonFOLInferenceProcedureTests.assertFalse(answer.isPartialResultDueToTimeout());
            CommonFOLInferenceProcedureTests.assertTrue(1 == answer.getProofs().size());
            CommonFOLInferenceProcedureTests.assertTrue(0 == answer.getProofs().get(0).getAnswerBindings().size());
        }
    }
}

