/*
 * Decompiled with CFR 0.152.
 */
package aima.search.informed;

import aima.search.framework.Node;
import aima.search.framework.NodeExpander;
import aima.search.framework.Problem;
import aima.search.framework.Search;
import aima.search.framework.SearchUtils;
import aima.search.informed.Scheduler;
import aima.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class SimulatedAnnealingSearch
extends NodeExpander
implements Search {
    private final Scheduler scheduler;
    private SearchOutcome outcome = SearchOutcome.FAILURE;
    private Object lastState = null;

    public SimulatedAnnealingSearch() {
        this.scheduler = new Scheduler();
    }

    @Override
    public List<String> search(Problem p) throws Exception {
        this.clearInstrumentation();
        this.outcome = SearchOutcome.FAILURE;
        this.lastState = null;
        Node current = new Node(p.getInitialState());
        Node next = null;
        ArrayList<String> ret = new ArrayList();
        int timeStep = 0;
        while (true) {
            double deltaE;
            double temperature = this.scheduler.getTemp(timeStep);
            ++timeStep;
            if (temperature == 0.0) {
                if (p.isGoalState(current.getState())) {
                    this.outcome = SearchOutcome.SOLUTION_FOUND;
                }
                break;
            }
            List<Node> children = this.expandNode(current, p);
            if (children.size() <= 0 || !this.shouldAccept(temperature, deltaE = this.getValue(p, next = Util.selectRandomlyFromList(children)) - this.getValue(p, current))) continue;
            current = next;
        }
        ret = SearchUtils.actionsFromNodes(current.getPathFromRoot());
        this.lastState = current.getState();
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldAccept(double temperature, double deltaE) {
        if (deltaE > 0.0) return true;
        Random random = new Random();
        if (!(random.nextDouble() <= this.probabilityOfAcceptance(temperature, deltaE))) return false;
        return true;
    }

    public double probabilityOfAcceptance(double temperature, double deltaE) {
        return Math.exp(deltaE / temperature);
    }

    public SearchOutcome getOutcome() {
        return this.outcome;
    }

    public Object getLastSearchState() {
        return this.lastState;
    }

    private double getValue(Problem p, Node n) {
        return -1.0 * this.getHeuristic(p, n);
    }

    private double getHeuristic(Problem p, Node aNode) {
        return p.getHeuristicFunction().getHeuristicValue(aNode.getState());
    }

    public static enum SearchOutcome {
        FAILURE,
        SOLUTION_FOUND;

    }
}

