/*
 * Decompiled with CFR 0.152.
 */
package aima.probability.decision.cellworld;

import aima.probability.Randomizer;
import aima.probability.decision.MDP;
import aima.probability.decision.MDPPerception;
import aima.probability.decision.MDPRewardFunction;
import aima.probability.decision.MDPSource;
import aima.probability.decision.MDPTransitionModel;
import aima.probability.decision.cellworld.Cell;
import aima.probability.decision.cellworld.CellWorldPosition;
import aima.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

public class CellWorld
implements MDPSource<CellWorldPosition, String> {
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String UP = "up";
    public static final String DOWN = "down";
    public static final String NO_OP = "no_op";
    List<Cell> blockedCells;
    List<Cell> allCells = new ArrayList<Cell>();
    private int numberOfRows;
    private int numberOfColumns;
    private List<Cell> terminalStates;
    private Cell initialState;

    public CellWorld(int numberOfRows, int numberOfColumns, double initialReward) {
        this.blockedCells = new ArrayList<Cell>();
        this.terminalStates = new ArrayList<Cell>();
        this.numberOfRows = numberOfRows;
        this.numberOfColumns = numberOfColumns;
        for (int row = 1; row <= numberOfRows; ++row) {
            for (int col = 1; col <= numberOfColumns; ++col) {
                this.allCells.add(new Cell(row, col, initialReward));
            }
        }
        this.initialState = this.getCellAt(1, 4);
    }

    public void markBlocked(int i, int j) {
        this.blockedCells.add(this.getCellAt(i, j));
    }

    private boolean isBlocked(int i, int j) {
        if (i < 1 || i > this.numberOfRows || j < 1 || j > this.numberOfColumns) {
            return true;
        }
        for (Cell c : this.blockedCells) {
            if (c.getX() != i || c.getY() != j) continue;
            return true;
        }
        return false;
    }

    private Cell getCellAt(int i, int j) {
        for (Cell c : this.allCells) {
            if (c.getX() != i || c.getY() != j) continue;
            return c;
        }
        throw new RuntimeException("No Cell found at " + i + " , " + j);
    }

    public CellWorldPosition moveProbabilisticallyFrom(int i, int j, String direction, Randomizer r) {
        Cell c = this.getCellAt(i, j);
        if (this.terminalStates.contains(c)) {
            return c.position();
        }
        return this.moveFrom(i, j, this.determineDirectionOfActualMovement(direction, r));
    }

    private CellWorldPosition moveFrom(int i, int j, String direction) {
        if (direction.equals(LEFT)) {
            return this.moveLeftFrom(i, j);
        }
        if (direction.equals(RIGHT)) {
            return this.moveRightFrom(i, j);
        }
        if (direction.equals(UP)) {
            return this.moveUpFrom(i, j);
        }
        if (direction.equals(DOWN)) {
            return this.moveDownFrom(i, j);
        }
        throw new RuntimeException("Unable to move " + direction + " from " + i + " , " + j);
    }

    private CellWorldPosition moveFrom(CellWorldPosition startingPosition, String direction) {
        return this.moveFrom(startingPosition.getX(), startingPosition.getY(), direction);
    }

    private String determineDirectionOfActualMovement(String commandedDirection, double prob) {
        if (prob < 0.8) {
            return commandedDirection;
        }
        if (prob > 0.8 && prob < 0.9) {
            if (commandedDirection.equals(LEFT) || commandedDirection.equals(RIGHT)) {
                return UP;
            }
            if (commandedDirection.equals(UP) || commandedDirection.equals(DOWN)) {
                return LEFT;
            }
        } else {
            if (commandedDirection.equals(LEFT) || commandedDirection.equals(RIGHT)) {
                return DOWN;
            }
            if (commandedDirection.equals(UP) || commandedDirection.equals(DOWN)) {
                return RIGHT;
            }
        }
        throw new RuntimeException("Unable to determine direction when command =  " + commandedDirection + " and probability = " + prob);
    }

    private String determineDirectionOfActualMovement(String commandedDirection, Randomizer r) {
        return this.determineDirectionOfActualMovement(commandedDirection, r.nextDouble());
    }

    private CellWorldPosition moveLeftFrom(int i, int j) {
        if (this.isBlocked(i, j - 1)) {
            return new CellWorldPosition(i, j);
        }
        return new CellWorldPosition(i, j - 1);
    }

    private CellWorldPosition moveRightFrom(int i, int j) {
        if (this.isBlocked(i, j + 1)) {
            return new CellWorldPosition(i, j);
        }
        return new CellWorldPosition(i, j + 1);
    }

    private CellWorldPosition moveUpFrom(int i, int j) {
        if (this.isBlocked(i + 1, j)) {
            return new CellWorldPosition(i, j);
        }
        return new CellWorldPosition(i + 1, j);
    }

    private CellWorldPosition moveDownFrom(int i, int j) {
        if (this.isBlocked(i - 1, j)) {
            return new CellWorldPosition(i, j);
        }
        return new CellWorldPosition(i - 1, j);
    }

    public void setReward(int i, int j, double reward) {
        Cell c = this.getCellAt(i, j);
        c.setReward(reward);
    }

    public List<Cell> unblockedCells() {
        ArrayList<Cell> res = new ArrayList<Cell>();
        for (Cell c : this.allCells) {
            if (this.blockedCells.contains(c)) continue;
            res.add(c);
        }
        return res;
    }

    public boolean isBlocked(Pair<Integer, Integer> p) {
        return this.isBlocked(p.getFirst(), p.getSecond());
    }

    public double getTransitionProbability(CellWorldPosition startingPosition, String actionDesired, CellWorldPosition endingPosition) {
        String firstRightAngledAction = this.determineDirectionOfActualMovement(actionDesired, 0.85);
        String secondRightAngledAction = this.determineDirectionOfActualMovement(actionDesired, 0.95);
        Hashtable<String, CellWorldPosition> actionsToPositions = new Hashtable<String, CellWorldPosition>();
        actionsToPositions.put(actionDesired, this.moveFrom(startingPosition, actionDesired));
        actionsToPositions.put(firstRightAngledAction, this.moveFrom(startingPosition, firstRightAngledAction));
        actionsToPositions.put(secondRightAngledAction, this.moveFrom(startingPosition, secondRightAngledAction));
        Hashtable<CellWorldPosition, Double> positionsToProbability = new Hashtable<CellWorldPosition, Double>();
        for (CellWorldPosition p : actionsToPositions.values()) {
            positionsToProbability.put(p, 0.0);
        }
        for (String action : actionsToPositions.keySet()) {
            CellWorldPosition position = (CellWorldPosition)actionsToPositions.get(action);
            double value = (Double)positionsToProbability.get(position);
            if (action.equals(actionDesired)) {
                positionsToProbability.put(position, value + 0.8);
                continue;
            }
            positionsToProbability.put(position, value + 0.1);
        }
        if (positionsToProbability.keySet().contains(endingPosition)) {
            return (Double)positionsToProbability.get(endingPosition);
        }
        return 0.0;
    }

    @Override
    public MDPTransitionModel<CellWorldPosition, String> getTransitionModel() {
        ArrayList<CellWorldPosition> terminalPositions = new ArrayList<CellWorldPosition>();
        for (Cell tc : this.terminalStates) {
            terminalPositions.add(tc.position());
        }
        MDPTransitionModel<CellWorldPosition, String> mtm = new MDPTransitionModel<CellWorldPosition, String>(terminalPositions);
        List<String> actions2 = Arrays.asList(UP, DOWN, LEFT, RIGHT);
        for (CellWorldPosition startingPosition : this.getNonFinalStates()) {
            for (String actionDesired : actions2) {
                for (Cell target : this.unblockedCells()) {
                    CellWorldPosition endingPosition = target.position();
                    double transitionProbability = this.getTransitionProbability(startingPosition, actionDesired, endingPosition);
                    if (transitionProbability == 0.0) continue;
                    mtm.setTransitionProbability(startingPosition, actionDesired, endingPosition, transitionProbability);
                }
            }
        }
        return mtm;
    }

    @Override
    public MDPRewardFunction<CellWorldPosition> getRewardFunction() {
        MDPRewardFunction<CellWorldPosition> result = new MDPRewardFunction<CellWorldPosition>();
        for (Cell c : this.unblockedCells()) {
            CellWorldPosition pos = c.position();
            double reward = c.getReward();
            result.setReward(pos, reward);
        }
        return result;
    }

    public List<CellWorldPosition> unblockedPositions() {
        ArrayList<CellWorldPosition> result = new ArrayList<CellWorldPosition>();
        for (Cell c : this.unblockedCells()) {
            result.add(c.position());
        }
        return result;
    }

    @Override
    public MDP<CellWorldPosition, String> asMdp() {
        return new MDP<CellWorldPosition, String>(this);
    }

    @Override
    public List<CellWorldPosition> getNonFinalStates() {
        List<CellWorldPosition> nonFinalPositions = this.unblockedPositions();
        nonFinalPositions.remove(this.getCellAt(2, 4).position());
        nonFinalPositions.remove(this.getCellAt(3, 4).position());
        return nonFinalPositions;
    }

    @Override
    public List<CellWorldPosition> getFinalStates() {
        ArrayList<CellWorldPosition> finalPositions = new ArrayList<CellWorldPosition>();
        finalPositions.add(this.getCellAt(2, 4).position());
        finalPositions.add(this.getCellAt(3, 4).position());
        return finalPositions;
    }

    public void setTerminalState(int i, int j) {
        this.setTerminalState(new CellWorldPosition(i, j));
    }

    public void setTerminalState(CellWorldPosition position) {
        this.terminalStates.add(this.getCellAt(position.getX(), position.getY()));
    }

    @Override
    public CellWorldPosition getInitialState() {
        return this.initialState.position();
    }

    @Override
    public MDPPerception<CellWorldPosition> execute(CellWorldPosition position, String action, Randomizer r) {
        CellWorldPosition pos = this.moveProbabilisticallyFrom(position.getX(), position.getY(), action, r);
        double reward = this.getCellAt(pos.getX(), pos.getY()).getReward();
        return new MDPPerception<CellWorldPosition>(pos, reward);
    }

    @Override
    public List<String> getAllActions() {
        return Arrays.asList(LEFT, RIGHT, UP, DOWN);
    }
}

