/*
 * Decompiled with CFR 0.152.
 */
package aima.logic.fol;

import aima.logic.fol.StandardizeApartIndexical;
import aima.logic.fol.StandardizeApartResult;
import aima.logic.fol.SubstVisitor;
import aima.logic.fol.VariableCollector;
import aima.logic.fol.inference.proof.ProofStepRenaming;
import aima.logic.fol.kb.data.Chain;
import aima.logic.fol.kb.data.Clause;
import aima.logic.fol.kb.data.Literal;
import aima.logic.fol.parsing.ast.AtomicSentence;
import aima.logic.fol.parsing.ast.Sentence;
import aima.logic.fol.parsing.ast.Term;
import aima.logic.fol.parsing.ast.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StandardizeApart {
    private VariableCollector variableCollector = null;
    private SubstVisitor substVisitor = null;

    public StandardizeApart() {
        this.variableCollector = new VariableCollector();
        this.substVisitor = new SubstVisitor();
    }

    public StandardizeApart(VariableCollector variableCollector, SubstVisitor substVisitor) {
        this.variableCollector = variableCollector;
        this.substVisitor = substVisitor;
    }

    public StandardizeApartResult standardizeApart(Sentence aSentence, StandardizeApartIndexical standardizeApartIndexical) {
        Set<Variable> toRename = this.variableCollector.collectAllVariables(aSentence);
        HashMap<Variable, Term> renameSubstitution = new HashMap<Variable, Term>();
        HashMap<Variable, Term> reverseSubstitution = new HashMap<Variable, Term>();
        for (Variable var : toRename) {
            Variable v = null;
            while (toRename.contains(v = new Variable(standardizeApartIndexical.getPrefix() + standardizeApartIndexical.getNextIndex()))) {
            }
            renameSubstitution.put(var, v);
            reverseSubstitution.put(v, var);
        }
        Sentence standardized = this.substVisitor.subst(renameSubstitution, aSentence);
        return new StandardizeApartResult(aSentence, standardized, renameSubstitution, reverseSubstitution);
    }

    public Clause standardizeApart(Clause clause, StandardizeApartIndexical standardizeApartIndexical) {
        Set<Variable> toRename = this.variableCollector.collectAllVariables(clause);
        HashMap<Variable, Term> renameSubstitution = new HashMap<Variable, Term>();
        for (Variable variable : toRename) {
            Variable v = null;
            while (toRename.contains(v = new Variable(standardizeApartIndexical.getPrefix() + standardizeApartIndexical.getNextIndex()))) {
            }
            renameSubstitution.put(variable, v);
        }
        if (renameSubstitution.size() > 0) {
            ArrayList<Literal> literals = new ArrayList<Literal>();
            for (Literal l : clause.getLiterals()) {
                literals.add(this.substVisitor.subst(renameSubstitution, l));
            }
            Clause clause2 = new Clause(literals);
            clause2.setProofStep(new ProofStepRenaming(clause2, clause.getProofStep()));
            return clause2;
        }
        return clause;
    }

    public Chain standardizeApart(Chain chain, StandardizeApartIndexical standardizeApartIndexical) {
        Set<Variable> toRename = this.variableCollector.collectAllVariables(chain);
        HashMap<Variable, Term> renameSubstitution = new HashMap<Variable, Term>();
        for (Variable variable : toRename) {
            Variable v = null;
            while (toRename.contains(v = new Variable(standardizeApartIndexical.getPrefix() + standardizeApartIndexical.getNextIndex()))) {
            }
            renameSubstitution.put(variable, v);
        }
        if (renameSubstitution.size() > 0) {
            ArrayList<Literal> lits = new ArrayList<Literal>();
            for (Literal l : chain.getLiterals()) {
                AtomicSentence atom = (AtomicSentence)this.substVisitor.subst(renameSubstitution, l.getAtomicSentence());
                lits.add(l.newInstance(atom));
            }
            Chain chain2 = new Chain(lits);
            chain2.setProofStep(new ProofStepRenaming(chain2, chain.getProofStep()));
            return chain2;
        }
        return chain;
    }

    public Map<Variable, Term> standardizeApart(List<Literal> l1Literals, List<Literal> l2Literals, StandardizeApartIndexical standardizeApartIndexical) {
        HashSet<Variable> toRename = new HashSet<Variable>();
        for (Literal literal : l1Literals) {
            toRename.addAll(this.variableCollector.collectAllVariables(literal.getAtomicSentence()));
        }
        for (Literal literal : l2Literals) {
            toRename.addAll(this.variableCollector.collectAllVariables(literal.getAtomicSentence()));
        }
        HashMap<Variable, Term> renameSubstitution = new HashMap<Variable, Term>();
        for (Variable var : toRename) {
            Variable v = null;
            while (toRename.contains(v = new Variable(standardizeApartIndexical.getPrefix() + standardizeApartIndexical.getNextIndex()))) {
            }
            renameSubstitution.put(var, v);
        }
        ArrayList<Literal> arrayList = new ArrayList<Literal>();
        ArrayList<Literal> negLits = new ArrayList<Literal>();
        for (Literal pl : l1Literals) {
            arrayList.add(this.substVisitor.subst(renameSubstitution, pl));
        }
        for (Literal nl : l2Literals) {
            negLits.add(this.substVisitor.subst(renameSubstitution, nl));
        }
        l1Literals.clear();
        l1Literals.addAll(arrayList);
        l2Literals.clear();
        l2Literals.addAll(negLits);
        return renameSubstitution;
    }
}

